/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.RichTextArea;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.components.HelpLayout;
import org.apertereports.components.HelpWindow;
import org.apertereports.components.ModalWindow;
import org.apertereports.dao.CyclicReportOrderDAO;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.dashboard.AbstractDashboardComponent;
import org.apertereports.model.CyclicReportOrder;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.DashboardUtil;
import org.apertereports.util.VaadinUtil;

public class EditDashboardComponent
extends AbstractDashboardComponent {
    private RichTextArea richTextArea = new RichTextArea();
    private TextArea simpleTextArea = new TextArea();
    private Panel textPanel;
    private boolean isRichTextEnabled;
    private Button saveButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.save"));
    private Button cancelButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.cancel"));
    private Button showSourceButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.source"));
    private Button addReportButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.add.report"));
    private Panel mainPanel = new Panel();
    private Table reportsTable = new Table();
    private Window reportDetailsWindow;

    public EditDashboardComponent() {
        this.mainPanel.setScrollable(true);
        this.mainPanel.setStyleName("borderless light");
        this.mainPanel.setSizeUndefined();
        this.initView();
        this.initData();
        this.setCompositionRoot((Component)this.mainPanel);
    }

    protected void initComponentData() {
        this.initReportsTable();
        this.initTextArea();
    }

    private void initView() {
        HelpLayout helpLayout = new HelpLayout(HelpWindow.Module.DASHBOARD, HelpWindow.Tab.EDIT_REPORT);
        this.mainPanel.addComponent((Component)helpLayout);
        String idxId = VaadinUtil.getValue((String)"dashboard.edit.table.idx");
        String detailsId = VaadinUtil.getValue((String)"dashboard.edit.table.details");
        String deleteId = VaadinUtil.getValue((String)"dashboard.edit.table.delete");
        String descriptionId = VaadinUtil.getValue((String)"dashboard.edit.table.description");
        this.reportsTable.addContainerProperty((Object)idxId, Integer.class, null);
        this.reportsTable.addContainerProperty((Object)VaadinUtil.getValue((String)"dashboard.edit.table.report"), String.class, null);
        this.reportsTable.addContainerProperty((Object)descriptionId, String.class, null);
        this.reportsTable.addContainerProperty((Object)VaadinUtil.getValue((String)"dashboard.edit.table.type"), String.class, null);
        this.reportsTable.addContainerProperty((Object)detailsId, Button.class, null);
        this.reportsTable.addContainerProperty((Object)deleteId, Button.class, null);
        this.reportsTable.setColumnWidth((Object)idxId, 20);
        this.reportsTable.setColumnWidth((Object)detailsId, 80);
        this.reportsTable.setColumnWidth((Object)deleteId, 50);
        this.reportsTable.setColumnExpandRatio((Object)descriptionId, 1.0f);
        this.reportsTable.setWidth(600.0f, 0);
        this.reportsTable.setSelectable(false);
        this.reportsTable.setImmediate(true);
        this.reportsTable.setPageLength(10);
        this.richTextArea.setSizeFull();
        this.simpleTextArea.setSizeFull();
        this.textPanel = new Panel();
        this.textPanel.setScrollable(true);
        this.textPanel.setStyleName("borderless light");
        this.textPanel.setSizeUndefined();
        VerticalLayout textLayout = new VerticalLayout();
        textLayout.setHeight(200.0f, 0);
        textLayout.setWidth(600.0f, 0);
        this.textPanel.setContent((ComponentContainer)textLayout);
        VerticalLayout table = new VerticalLayout();
        table.setSpacing(true);
        table.setMargin(false);
        table.addComponent((Component)this.reportsTable);
        table.addComponent((Component)this.addReportButton);
        table.setComponentAlignment((Component)this.addReportButton, Alignment.MIDDLE_LEFT);
        table.setExpandRatio((Component)this.reportsTable, 1.0f);
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.setSizeUndefined();
        buttons.setSpacing(true);
        buttons.addComponent((Component)this.saveButton);
        buttons.addComponent((Component)this.cancelButton);
        buttons.addComponent((Component)this.showSourceButton);
        Iterator it = buttons.getComponentIterator();
        while (it.hasNext()) {
            buttons.setExpandRatio((Component)it.next(), 1.0f);
        }
        VerticalLayout splitLayout = new VerticalLayout();
        splitLayout.setSpacing(true);
        splitLayout.setMargin(false);
        splitLayout.addComponent((Component)this.textPanel);
        splitLayout.addComponent((Component)buttons);
        splitLayout.addComponent((Component)table);
        splitLayout.setExpandRatio((Component)table, 1.0f);
        this.mainPanel.addComponent((Component)splitLayout);
        this.showSourceButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addReportButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.saveButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void enableRichTextArea(boolean enable) {
        this.showSourceButton.setCaption(VaadinUtil.getValue((String)(enable ? "dashboard.edit.source" : "dashboard.edit.source.disable")));
        this.textPanel.removeAllComponents();
        this.textPanel.addComponent((Component)(enable ? this.richTextArea : this.simpleTextArea));
        this.isRichTextEnabled = enable;
    }

    private boolean validate() {
        Set templateIds = DashboardUtil.getReportConfigIds((String)this.template);
        HashSet<Integer> configIds = new HashSet<Integer>();
        for (ReportConfig rc : this.reportConfigs) {
            configIds.add(rc.getId());
        }
        return configIds.containsAll(templateIds);
    }

    private void initTextArea() {
        this.enableRichTextArea(true);
        this.richTextArea.setValue((Object)(this.template != null ? this.template : ""));
    }

    private void initReportsTable() {
        HashSet<Integer> reportIds = new HashSet<Integer>();
        HashSet<Long> cyclicReportIds = new HashSet<Long>();
        if (this.reportConfigs != null && !this.reportConfigs.isEmpty()) {
            for (ReportConfig r : this.reportConfigs) {
                if (r.getReportId() != null) {
                    reportIds.add(r.getReportId());
                    continue;
                }
                if (r.getCyclicReportId() == null) continue;
                cyclicReportIds.add(r.getCyclicReportId());
            }
        }
        this.reportsTable.removeAllItems();
        if (!reportIds.isEmpty() || !cyclicReportIds.isEmpty()) {
            List cyclicReports = CyclicReportOrderDAO.fetchCyclicReportsByIds((Long[])cyclicReportIds.toArray(new Long[cyclicReportIds.size()]));
            HashMap<Long, CyclicReportOrder> cyclicReportOrders = new HashMap<Long, CyclicReportOrder>();
            for (CyclicReportOrder rep : cyclicReports) {
                cyclicReportOrders.put(rep.getId(), rep);
                reportIds.add(rep.getReport().getId());
            }
            List reports = ReportTemplateDAO.fetchReports((Integer[])reportIds.toArray(new Integer[reportIds.size()]));
            HashMap<Integer, ReportTemplate> reportOrders = new HashMap<Integer, ReportTemplate>();
            for (ReportTemplate rep : reports) {
                reportOrders.put(rep.getId(), rep);
            }
            ArrayList<ReportConfig> configList = new ArrayList<ReportConfig>();
            for (ReportConfig r : this.reportConfigs) {
                CyclicReportOrder cyclicRep;
                ReportTemplate rep = null;
                String reportType = null;
                if (r.getReportId() != null) {
                    rep = (ReportTemplate)reportOrders.get(r.getReportId());
                    reportType = VaadinUtil.getValue((String)"dashboard.edit.table.type.online");
                } else if (r.getCyclicReportId() != null && (cyclicRep = (CyclicReportOrder)cyclicReportOrders.get(r.getCyclicReportId())) != null) {
                    rep = (ReportTemplate)reportOrders.get(cyclicRep.getReport().getId());
                    reportType = VaadinUtil.getValue((String)"dashboard.edit.table.type.cyclic");
                    r.setParameters(XmlReportConfigLoader.getInstance().xmlAsParameters(cyclicRep.getParametersXml()));
                }
                if (rep == null) continue;
                configList.add(r);
                Button details = new Button(VaadinUtil.getValue((String)"dashboard.edit.table.details"));
                Button delete = new Button(VaadinUtil.getValue((String)"dashboard.edit.table.delete"));
                this.reportsTable.addItem(new Object[]{r.getId(), rep.getReportname(), rep.getDescription(), reportType, details, delete}, (Object)r.getId());
                delete.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                ReportTemplate finalRep = rep;
                details.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.reportConfigs = configList;
        }
    }

    private void addNewReport() {
        this.showDetails(null, null);
    }

    private void showDetails(ReportConfig config, ReportTemplate report) {
        this.reportDetailsWindow = new ModalWindow(VaadinUtil.getValue((String)"dashboard.edit.report.details"), (Component)new /* Unavailable Anonymous Inner Class!! */);
        this.reportDetailsWindow.addListener((Window.CloseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getWindow().addWindow(this.reportDetailsWindow);
    }

    private void removeReportDetailsWindow() {
        if (this.reportDetailsWindow != null) {
            this.getWindow().removeWindow(this.reportDetailsWindow);
            this.reportDetailsWindow = null;
        }
    }

    static /* synthetic */ boolean access$000(EditDashboardComponent x0) {
        return x0.isRichTextEnabled;
    }

    static /* synthetic */ void access$100(EditDashboardComponent x0, boolean x1) {
        x0.enableRichTextArea(x1);
    }

    static /* synthetic */ TextArea access$200(EditDashboardComponent x0) {
        return x0.simpleTextArea;
    }

    static /* synthetic */ RichTextArea access$300(EditDashboardComponent x0) {
        return x0.richTextArea;
    }

    static /* synthetic */ void access$400(EditDashboardComponent x0) {
        x0.addNewReport();
    }

    static /* synthetic */ boolean access$500(EditDashboardComponent x0) {
        return x0.validate();
    }

    static /* synthetic */ Table access$600(EditDashboardComponent x0) {
        return x0.reportsTable;
    }

    static /* synthetic */ void access$700(EditDashboardComponent x0, ReportConfig x1, ReportTemplate x2) {
        x0.showDetails(x1, x2);
    }

    static /* synthetic */ void access$800(EditDashboardComponent x0) {
        x0.removeReportDetailsWindow();
    }

    static /* synthetic */ void access$900(EditDashboardComponent x0) {
        x0.initReportsTable();
    }
}

