/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard;

import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.IntegerValidator;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Select;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import eu.livotov.tpt.gui.widgets.TPTLazyLoadingLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.components.HelpLayout;
import org.apertereports.components.HelpWindow;
import org.apertereports.components.ReportParametersComponent;
import org.apertereports.components.SimpleHorizontalLayout;
import org.apertereports.dao.CyclicReportOrderDAO;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.dashboard.cyclic.CyclicReportsPanel;
import org.apertereports.model.CyclicReportOrder;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;

public abstract class ReportDetailsComponent
extends CustomComponent {
    private ReportTemplate reportTemplate;
    private ReportConfig reportConfig;
    private Object selectedItem = null;
    private Button saveButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.save"));
    private Button cancelButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.cancel"));
    private Button openCyclicReportsButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.cyclicReports"));
    private VerticalLayout mainPanel = new VerticalLayout();
    private VerticalLayout reportDetailsPanel = new VerticalLayout();
    private Select reportSelect;
    private ReportParametersComponent reportParametersComponent;
    private Panel reportParametersPanel = new Panel(VaadinUtil.getValue((String)"dashboard.edit.report.parameters"));
    private TextField cacheTimeoutField = new TextField();
    private CheckBox allowRefreshField = new CheckBox();
    private Map<String, CheckBox> formatsMap = new HashMap();
    private boolean readonly;
    private CyclicReportsPanel cyclicReportsPanel;

    public ReportDetailsComponent(ReportTemplate reportTemplate, ReportConfig reportConfig, boolean readonly) {
        this.reportTemplate = reportTemplate;
        this.reportConfig = reportConfig;
        this.readonly = readonly;
        this.initView();
        this.initData();
        this.setCompositionRoot((Component)this.mainPanel);
    }

    private Component getButtonsPanel() {
        this.saveButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.openCyclicReportsButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return new SimpleHorizontalLayout(new Component[]{this.saveButton, this.cancelButton, this.openCyclicReportsButton});
    }

    private void openEditCyclicReports() {
        this.cyclicReportsPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.setCompositionRoot((Component)this.cyclicReportsPanel);
    }

    private void initView() {
        HelpLayout helpLayout = new HelpLayout(HelpWindow.Module.DASHBOARD, HelpWindow.Tab.REPORT_DETAILS);
        this.mainPanel.addComponent((Component)helpLayout);
        this.mainPanel.addComponent((Component)this.reportDetailsPanel);
        this.mainPanel.addComponent(this.getButtonsPanel());
        this.mainPanel.setSizeFull();
        this.reportSelect = new Select(VaadinUtil.getValue((String)"dashboard.edit.table.report"));
        this.reportSelect.setImmediate(true);
        this.reportSelect.setFilteringMode(2);
        this.reportSelect.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.reportDetailsPanel.addComponent((Component)this.reportSelect);
        this.reportParametersPanel.setHeight(400.0f, 0);
        this.reportParametersPanel.setWidth(600.0f, 0);
        VerticalLayout vl = new VerticalLayout();
        vl.setHeight(-1.0f, 0);
        vl.setWidth(100.0f, 8);
        vl.setSpacing(true);
        this.reportParametersPanel.setContent((ComponentContainer)vl);
        this.reportParametersPanel.setScrollable(true);
        this.reportDetailsPanel.addComponent((Component)this.reportParametersPanel);
        this.cacheTimeoutField.setRequired(true);
        this.cacheTimeoutField.setInvalidAllowed(false);
        this.cacheTimeoutField.setImmediate(true);
        this.cacheTimeoutField.setMaxLength(4);
        this.cacheTimeoutField.setColumns(3);
        this.cacheTimeoutField.addValidator((Validator)new IntegerValidator(VaadinUtil.getValue((String)"dashboard.edit.report.cacheTimeout.error")));
        this.cacheTimeoutField.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.reportDetailsPanel.addComponent((Component)new SimpleHorizontalLayout(new Component[]{new Label(VaadinUtil.getValue((String)"dashboard.edit.report.cacheTimeout")), this.cacheTimeoutField, new Label(" s [" + VaadinUtil.getValue((String)"dashboard.edit.report.cacheTimeout.instructions") + "]")}));
        HorizontalLayout hl = new HorizontalLayout();
        hl.setSpacing(true);
        hl.setSizeFull();
        hl.addComponent((Component)new Label(VaadinUtil.getValue((String)"dashboard.edit.report.allowRefresh")));
        hl.addComponent((Component)this.allowRefreshField);
        this.reportDetailsPanel.addComponent((Component)hl);
        for (ReportConstants.ReportType rt : ReportConstants.ReportType.values()) {
            this.formatsMap.put(rt.name(), new CheckBox(rt.name()));
        }
        GridLayout grid = new GridLayout(this.formatsMap.values().size(), 1);
        grid.setSizeFull();
        grid.setSpacing(true);
        for (CheckBox cb : this.formatsMap.values()) {
            grid.addComponent((Component)cb);
        }
        for (int i = 0; i < grid.getColumns(); ++i) {
            grid.setColumnExpandRatio(i, 2.0f);
        }
        this.reportDetailsPanel.addComponent((Component)new SimpleHorizontalLayout(new Component[]{new Label(VaadinUtil.getValue((String)"dashboard.edit.report.formats")), grid}));
    }

    private boolean validate() {
        boolean formatSelected = false;
        for (CheckBox cb : this.formatsMap.values()) {
            if (!cb.booleanValue()) continue;
            formatSelected = true;
            break;
        }
        return this.reportSelect.getValue() != null && this.reportParametersComponent != null && this.reportParametersComponent.validateForm() && this.cacheTimeoutField.isValid() && formatSelected;
    }

    private void initData() {
        String reportType = VaadinUtil.getValue((String)"dashboard.edit.table.type.online");
        Collection reports = ReportTemplateDAO.fetchAllReports((boolean)true);
        for (ReportTemplate rep : reports) {
            this.reportSelect.addItem((Object)rep);
            this.reportSelect.setItemCaption((Object)rep, reportType + ": " + rep.getReportname() + " (" + rep.getDescription() + ")");
            if (this.reportConfig == null || !rep.getId().equals(this.reportConfig.getReportId())) continue;
            this.reportSelect.setValue((Object)rep);
        }
        reportType = VaadinUtil.getValue((String)"dashboard.edit.table.type.cyclic");
        Collection cyclicReportOrders = CyclicReportOrderDAO.fetchAllEnabledCyclicReports();
        for (CyclicReportOrder rep : cyclicReportOrders) {
            ReportTemplate r = rep.getReport();
            this.reportSelect.addItem((Object)rep);
            this.reportSelect.setItemCaption((Object)rep, reportType + ": " + r.getReportname() + " (" + r.getDescription() + ")");
            if (this.reportConfig == null || !rep.getId().equals(this.reportConfig.getCyclicReportId())) continue;
            this.reportSelect.setValue((Object)rep);
        }
        this.initReportParameters();
        this.initOtherParams();
    }

    private void initOtherParams() {
        if (this.reportConfig != null) {
            if (this.reportConfig.getCacheTimeout() != null) {
                this.cacheTimeoutField.setValue((Object)this.reportConfig.getCacheTimeout().toString());
            }
            this.allowRefreshField.setValue((Object)this.reportConfig.getAllowRefresh());
            for (String format : this.reportConfig.getAllowedFormatsAsList()) {
                CheckBox cb = (CheckBox)this.formatsMap.get(format);
                if (cb == null) continue;
                cb.setValue((Object)true);
            }
        }
    }

    private void initReportParameters() {
        this.reportParametersPanel.removeAllComponents();
        if (this.reportTemplate != null) {
            try {
                List params;
                List list = params = this.reportConfig != null ? this.reportConfig.getParameters() : null;
                if (this.selectedItem instanceof CyclicReportOrder) {
                    CyclicReportOrder cro = (CyclicReportOrder)this.selectedItem;
                    params = XmlReportConfigLoader.getInstance().xmlAsParameters(cro.getParametersXml() != null ? cro.getParametersXml() : "");
                }
                this.readonly = this.selectedItem instanceof CyclicReportOrder;
                this.reportParametersComponent = new ReportParametersComponent(this.reportTemplate.getContent(), this.reportTemplate.getId(), params, false, true, this.readonly);
                this.reportParametersPanel.addComponent((Component)new TPTLazyLoadingLayout((TPTLazyLoadingLayout.LazyLoader)this.reportParametersComponent, true));
            }
            catch (Exception e) {
                ExceptionUtils.logSevereException((Exception)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"exception.gui.error"));
                throw new RuntimeException(e);
            }
        }
        this.reportParametersPanel.setVisible(this.reportTemplate != null);
        this.saveButton.setEnabled(this.reportTemplate != null);
    }

    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    private void updateReportConfig() {
        if (this.reportConfig == null) {
            this.reportConfig = new ReportConfig();
        }
        ArrayList<String> allowedFormats = new ArrayList<String>();
        for (CheckBox cb : this.formatsMap.values()) {
            if (!cb.booleanValue()) continue;
            allowedFormats.add(cb.getCaption());
        }
        this.reportConfig.setAllowedFormatsFromList(allowedFormats);
        this.reportConfig.setAllowRefresh(Boolean.valueOf(this.allowRefreshField.booleanValue()));
        this.reportConfig.setCyclicReportId(this.selectedItem instanceof CyclicReportOrder ? ((CyclicReportOrder)this.selectedItem).getId() : null);
        this.reportConfig.setReportId(this.selectedItem instanceof CyclicReportOrder ? null : this.reportTemplate.getId());
        this.reportConfig.setCacheTimeout(Integer.valueOf(Integer.parseInt("" + this.cacheTimeoutField.getValue())));
        this.reportConfig.setParameters(XmlReportConfigLoader.getInstance().mapToParameterList(this.reportParametersComponent.collectParametersValues()));
    }

    public abstract void onCancel();

    public abstract void onConfirm();

    static /* synthetic */ boolean access$000(ReportDetailsComponent x0) {
        return x0.validate();
    }

    static /* synthetic */ Object access$102(ReportDetailsComponent x0, Object x1) {
        x0.selectedItem = x1;
        return x0.selectedItem;
    }

    static /* synthetic */ Select access$200(ReportDetailsComponent x0) {
        return x0.reportSelect;
    }

    static /* synthetic */ ReportTemplate access$302(ReportDetailsComponent x0, ReportTemplate x1) {
        x0.reportTemplate = x1;
        return x0.reportTemplate;
    }

    static /* synthetic */ Object access$100(ReportDetailsComponent x0) {
        return x0.selectedItem;
    }

    static /* synthetic */ void access$400(ReportDetailsComponent x0) {
        x0.updateReportConfig();
    }

    static /* synthetic */ void access$500(ReportDetailsComponent x0) {
        x0.openEditCyclicReports();
    }

    static /* synthetic */ void access$600(ReportDetailsComponent x0) {
        x0.initData();
    }

    static /* synthetic */ CyclicReportsPanel access$702(ReportDetailsComponent x0, CyclicReportsPanel x1) {
        x0.cyclicReportsPanel = x1;
        return x0.cyclicReportsPanel;
    }

    static /* synthetic */ VerticalLayout access$800(ReportDetailsComponent x0) {
        return x0.mainPanel;
    }

    static /* synthetic */ void access$900(ReportDetailsComponent x0, Component x1) {
        x0.setCompositionRoot(x1);
    }

    static /* synthetic */ void access$1000(ReportDetailsComponent x0) {
        x0.initReportParameters();
    }

    static /* synthetic */ TextField access$1100(ReportDetailsComponent x0) {
        return x0.cacheTimeoutField;
    }
}

