/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard;

import com.vaadin.Application;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.apertereports.AbstractLazyLoaderComponent;
import org.apertereports.backbone.util.ReportTemplateProvider;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsRuntimeException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.utils.TextUtils;
import org.apertereports.common.utils.TimeUtils;
import org.apertereports.common.wrappers.Pair;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.dao.CyclicReportOrderDAO;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.dao.utils.ConfigurationCache;
import org.apertereports.dashboard.html.HtmlReportBuilder;
import org.apertereports.dashboard.html.ReportDataProvider;
import org.apertereports.engine.ReportMaster;
import org.apertereports.engine.SubreportProvider;
import org.apertereports.model.CyclicReportOrder;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.DashboardUtil;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;
import org.apertereports.util.cache.MapCache;

public class ReportViewComponent
extends AbstractLazyLoaderComponent
implements ReportDataProvider {
    private static final Logger logger = Logger.getLogger(ReportViewComponent.class.getName());
    private Panel reportPanel = new Panel();
    private Map<Integer, ReportTemplate> reportMap = new HashMap();
    private Map<Integer, ReportConfig> configMap = new HashMap();
    private Map<Long, CyclicReportOrder> cyclicReportMap = new HashMap();
    private String template;
    private MapCache cache;
    private Application application;

    public ReportViewComponent(Application application, MapCache cache, String template, List<ReportConfig> configs, boolean lazyLoad) {
        this.application = application;
        this.cache = cache;
        this.template = template;
        this.initInternalData(configs);
        this.setCompositionRoot((Component)this.reportPanel);
        if (!lazyLoad) {
            this.init();
        }
    }

    private void init() {
        if (this.template != null && !this.template.isEmpty()) {
            HtmlReportBuilder builder = new HtmlReportBuilder(this.application, (ReportDataProvider)this);
            int[] index = new int[]{0};
            DashboardUtil.executeTemplateMatcherWithList((String)this.template, (Pattern)DashboardUtil.REPORT_TAG_PATTERN, (DashboardUtil.MatchHandlerWithList)new /* Unavailable Anonymous Inner Class!! */);
            builder.addHtmlChunk(this.template.substring(index[0]));
            try {
                this.reportPanel.addComponent((Component)builder.createLayout());
            }
            catch (IOException e) {
                ExceptionUtils.logSevereException((Exception)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"exception.gui.error"));
                throw new RuntimeException(e);
            }
        }
    }

    public ReportConfig generateDrilldownReportConfig(Map<String, List<String>> params) {
        ReportConfig drillConfig = new ReportConfig();
        List<String> reportNames = params.get("reportName");
        if (reportNames == null || reportNames.size() == 0) {
            throw new AperteReportsRuntimeException(ReportConstants.ErrorCodes.DRILLDOWN_NOT_FOUND);
        }
        String reportName = reportNames.get(0);
        for (ReportTemplate template : this.reportMap.values()) {
            if (!template.getReportname().equals(reportName)) continue;
            drillConfig.setReportId(template.getId());
            break;
        }
        if (drillConfig.getReportId() == null) {
            ReportTemplate template;
            List reportTemplates = ReportTemplateDAO.fetchReportsByName((String)reportName);
            if (reportTemplates.size() == 0) {
                throw new AperteReportsRuntimeException(ReportConstants.ErrorCodes.DRILLDOWN_REPORT_NOT_FOUND);
            }
            template = (ReportTemplate)reportTemplates.get(0);
            drillConfig.setReportId(template.getId());
        }
        drillConfig.setAllowRefresh(Boolean.valueOf(false));
        drillConfig.setCacheTimeout(Integer.valueOf(0));
        drillConfig.setId(DashboardUtil.generateDrilldownId(this.configMap.keySet()));
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        for (String key : params.keySet()) {
            List<String> values = params.get(key);
            if (key.equalsIgnoreCase("allowedFormats")) {
                ArrayList<String> allowedFormats = new ArrayList<String>();
                for (String f : values) {
                    String[] splitted;
                    for (String s : splitted = f.split(",")) {
                        allowedFormats.add(s);
                    }
                }
                drillConfig.setAllowedFormatsFromList(allowedFormats);
                continue;
            }
            if (key.equalsIgnoreCase("allowRefresh")) {
                if (values.size() != 1) continue;
                drillConfig.setAllowRefresh(Boolean.valueOf("true".equalsIgnoreCase(values.get(0))));
                continue;
            }
            if (key.equalsIgnoreCase("cacheTimeout")) {
                if (values.size() != 1) continue;
                drillConfig.setCacheTimeout(Integer.valueOf(Integer.parseInt(values.get(0))));
                continue;
            }
            if (values.size() <= 0) continue;
            String paramValue = values.size() == 1 ? TextUtils.encodeObjectToSQL((Object)values.get(0)) : TextUtils.encodeObjectToSQL(values);
            reportParameters.put(key, paramValue);
        }
        drillConfig.setParameters(XmlReportConfigLoader.getInstance().mapToParameterList(reportParameters));
        return drillConfig;
    }

    public ReportTemplate provideReportTemplate(ReportConfig config) {
        ReportTemplate report;
        if (!this.reportMap.containsKey(config.getReportId()) && (report = ReportTemplateDAO.fetchReport((Integer)config.getReportId())) != null) {
            this.reportMap.put(config.getReportId(), report);
        }
        return (ReportTemplate)this.reportMap.get(config.getReportId());
    }

    public Pair<JasperPrint, byte[]> provideReportData(ReportConfig config, ReportConstants.ReportType format, boolean cached) {
        try {
            JasperPrint jasperPrint = null;
            if (cached) {
                jasperPrint = (JasperPrint)this.cache.provideData(config.getId().toString());
            }
            if (jasperPrint == null) {
                HashMap parameters;
                ReportTemplate report = this.provideReportTemplate(config);
                if (report == null) {
                    throw new IllegalStateException("Report template not found");
                }
                ReportMaster reportMaster = new ReportMaster(report.getContent(), report.getId().toString(), (SubreportProvider)new ReportTemplateProvider());
                if (config.getCyclicReportId() != null) {
                    CyclicReportOrder cro = (CyclicReportOrder)this.cyclicReportMap.get(config.getCyclicReportId());
                    parameters = new HashMap(XmlReportConfigLoader.getInstance().xmlAsMap(cro.getParametersXml() != null ? cro.getParametersXml() : ""));
                } else {
                    parameters = new HashMap(XmlReportConfigLoader.getInstance().parameterListToMap(config.getParameters()));
                }
                jasperPrint = reportMaster.generateReport(parameters);
                this.cache.cacheData(config.getId().toString(), TimeUtils.secondsToMilliseconds((int)config.getCacheTimeout()), (Object)jasperPrint);
            }
            byte[] data = null;
            HashMap<JRHtmlExporterParameter, String> customParameters = null;
            if (ReportConstants.ReportType.HTML.equals((Object)format)) {
                customParameters = new HashMap<JRHtmlExporterParameter, String>();
                customParameters.put(JRHtmlExporterParameter.IMAGES_URI, "dashboardimage?image=");
            }
            data = ReportMaster.exportReport((JasperPrint)jasperPrint, (String)format.name(), customParameters, (Map)ConfigurationCache.getConfiguration());
            return new Pair((Object)jasperPrint, (Object)data);
        }
        catch (Exception e) {
            throw new AperteReportsRuntimeException(e);
        }
    }

    private void initInternalData(List<ReportConfig> configs) {
        Set configIds = DashboardUtil.getReportConfigIds((String)this.template);
        if (!configIds.isEmpty() && configs != null && !configs.isEmpty()) {
            HashSet<Integer> reportIds = new HashSet<Integer>();
            HashMap<Long, ReportConfig> cyclicConfigMap = new HashMap<Long, ReportConfig>();
            for (ReportConfig rc : configs) {
                if (!configIds.contains(rc.getId())) continue;
                this.configMap.put(rc.getId(), rc);
                if (rc.getCyclicReportId() != null) {
                    cyclicConfigMap.put(rc.getCyclicReportId(), rc);
                    continue;
                }
                reportIds.add(rc.getReportId());
            }
            List cyclicReports = CyclicReportOrderDAO.fetchCyclicReportsByIds((Long[])cyclicConfigMap.keySet().toArray(new Long[cyclicConfigMap.keySet().size()]));
            for (CyclicReportOrder rep : cyclicReports) {
                ReportConfig rc = (ReportConfig)cyclicConfigMap.get(rep.getId());
                rc.setReportId(rep.getReport().getId());
                reportIds.add(rep.getReport().getId());
                this.cyclicReportMap.put(rep.getId(), rep);
            }
            List reports = ReportTemplateDAO.fetchReports((Integer[])reportIds.toArray(new Integer[configIds.size()]));
            for (ReportTemplate rep : reports) {
                this.reportMap.put(rep.getId(), rep);
            }
        }
    }

    public void lazyLoad() throws Exception {
        this.init();
    }

    static /* synthetic */ String access$000(ReportViewComponent x0) {
        return x0.template;
    }

    static /* synthetic */ Map access$100(ReportViewComponent x0) {
        return x0.configMap;
    }
}

