/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard.cyclic;

import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Select;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import eu.livotov.tpt.gui.widgets.TPTLazyLoadingLayout;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.components.ReportParametersComponent;
import org.apertereports.components.SimpleHorizontalLayout;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.model.CyclicReportOrder;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;
import org.apertereports.util.validators.CronValidator;

public abstract class CyclicReportDetailsComponent
extends CustomComponent {
    private CyclicReportOrder cyclicReport;
    private VerticalLayout mainPanel = new VerticalLayout();
    private VerticalLayout reportDetailsPanel = new VerticalLayout();
    private ReportParametersComponent parametersComponent;
    private Panel reportParametersPanel = new Panel(VaadinUtil.getValue((String)"dashboard.edit.report.parameters"));
    private Select reportSelect;
    private ReportTemplate report;
    private TextField descriptionField = new TextField(VaadinUtil.getValue((String)"cyclic.report.table.desc"));
    private TextField statusField = new TextField(VaadinUtil.getValue((String)"cyclic.report.table.status"));
    private TextField cronExpressionField = new TextField(VaadinUtil.getValue((String)"cyclic.report.table.when"));
    private CheckBox enabledCheckBox = new CheckBox(VaadinUtil.getValue((String)"cyclic.report.enabled"));
    private TextField emailField = new TextField(VaadinUtil.getValue((String)"cyclic.report.email"));
    private Select outputFormatSelect = new Select(VaadinUtil.getValue((String)"cyclic.report.email.format"));
    private Button saveButton = new Button(VaadinUtil.getValue((String)"cyclic.report.update"));
    private Button cancelButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.cancel"));
    private Button downloadButton = new Button(VaadinUtil.getValue((String)"cyclic.report.download"));
    private Select downloadFormatSelect = new Select();

    public CyclicReportDetailsComponent(CyclicReportOrder cyclicReport) {
        this.cyclicReport = cyclicReport != null ? new CyclicReportOrder(cyclicReport) : new CyclicReportOrder();
        this.report = this.cyclicReport.getReport();
        this.initView();
        this.initData();
        this.setCompositionRoot((Component)this.mainPanel);
    }

    private void initData() {
        for (ReportConstants.ReportType rt : ReportConstants.ReportType.values()) {
            this.downloadFormatSelect.addItem((Object)rt);
            this.downloadFormatSelect.setItemCaption((Object)rt, rt.name());
            this.outputFormatSelect.addItem((Object)rt);
            this.outputFormatSelect.setItemCaption((Object)rt, rt.name());
        }
        this.reportSelect.removeAllItems();
        ArrayList reports = new ArrayList(ReportTemplateDAO.fetchAllReports((boolean)true));
        Collections.sort(reports, new /* Unavailable Anonymous Inner Class!! */);
        for (ReportTemplate rep : reports) {
            this.reportSelect.addItem((Object)rep);
            this.reportSelect.setItemCaption((Object)rep, rep.getReportname() + " (" + rep.getDescription() + ")");
            if (this.report == null || !rep.getId().equals(this.report.getId())) continue;
            this.reportSelect.setValue((Object)rep);
        }
        this.initReportParameters();
        this.initOtherReportData();
    }

    private String getStatusKey(ReportOrder.Status status) {
        if (ReportOrder.Status.FAILED.equals((Object)status)) {
            return "report_order.table.status.failed";
        }
        if (ReportOrder.Status.SUCCEEDED.equals((Object)status)) {
            return "report_order.table.status.succeeded";
        }
        if (ReportOrder.Status.PROCESSING.equals((Object)status)) {
            return "report_order.table.status.processing";
        }
        return "report_order.table.status.new";
    }

    private void initOtherReportData() {
        if (this.cyclicReport != null) {
            this.descriptionField.setValue((Object)(this.cyclicReport.getDescription() != null ? this.cyclicReport.getDescription() : ""));
            ReportOrder rep = this.cyclicReport.getProcessedOrder() != null ? this.cyclicReport.getProcessedOrder() : this.cyclicReport.getReportOrder();
            this.statusField.setValue((Object)VaadinUtil.getValue((String)this.getStatusKey(rep != null ? rep.getReportStatus() : null)));
            try {
                this.cronExpressionField.setValue((Object)(this.cyclicReport.getCronSpec() != null ? this.cyclicReport.getCronSpec() : ""));
            }
            catch (Validator.InvalidValueException e) {
                this.cronExpressionField.setValue((Object)"");
            }
            this.enabledCheckBox.setValue((Object)(this.cyclicReport.getEnabled() != null ? this.cyclicReport.getEnabled() : Boolean.FALSE));
            this.emailField.setValue((Object)(this.cyclicReport.getRecipientEmail() != null ? this.cyclicReport.getRecipientEmail() : ""));
            this.outputFormatSelect.setValue(this.cyclicReport.getOutputFormat() != null ? ReportConstants.ReportType.valueOf((String)this.cyclicReport.getOutputFormat()) : "");
        }
    }

    private void initView() {
        this.mainPanel.addComponent((Component)new Label(VaadinUtil.getValue((String)"cyclic.report.name") + ": " + (this.cyclicReport.getComponentId() != null ? this.cyclicReport.getComponentId() : VaadinUtil.getValue((String)"cyclic.report.new"))));
        this.mainPanel.addComponent((Component)this.reportDetailsPanel);
        this.mainPanel.addComponent(this.getButtonsPanel());
        this.mainPanel.setSpacing(true);
        this.mainPanel.setSizeFull();
        this.reportSelect = new Select(VaadinUtil.getValue((String)"dashboard.edit.table.report"));
        this.reportSelect.setWidth("-1px");
        this.reportSelect.setImmediate(true);
        this.reportSelect.setFilteringMode(2);
        this.reportSelect.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.reportDetailsPanel.addComponent((Component)this.reportSelect);
        this.reportDetailsPanel.addComponent((Component)this.reportParametersPanel);
        this.reportDetailsPanel.addComponent((Component)this.descriptionField);
        this.reportDetailsPanel.addComponent((Component)this.cronExpressionField);
        this.reportDetailsPanel.addComponent((Component)this.statusField);
        this.reportDetailsPanel.addComponent((Component)this.enabledCheckBox);
        this.reportDetailsPanel.addComponent((Component)this.emailField);
        this.reportDetailsPanel.addComponent((Component)this.outputFormatSelect);
        this.statusField.setEnabled(false);
        this.descriptionField.setRequired(true);
        this.emailField.setRequired(true);
        this.outputFormatSelect.setRequired(true);
        this.outputFormatSelect.setMultiSelect(false);
        this.outputFormatSelect.setImmediate(true);
        this.outputFormatSelect.setNullSelectionAllowed(false);
        this.outputFormatSelect.setWidth(6.0f, 3);
        this.outputFormatSelect.setFilteringMode(2);
        this.cronExpressionField.setRequired(true);
        this.cronExpressionField.addValidator((Validator)new CronValidator(VaadinUtil.getValue((String)"cyclic.report.when.validationError")));
        this.cronExpressionField.setInvalidAllowed(false);
        this.cronExpressionField.setImmediate(true);
        this.cronExpressionField.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.reportParametersPanel.setHeight(400.0f, 0);
        this.reportParametersPanel.setWidth(600.0f, 0);
        VerticalLayout vl = new VerticalLayout();
        vl.setHeight(-1.0f, 0);
        vl.setWidth(100.0f, 8);
        vl.setSpacing(true);
        this.reportParametersPanel.setContent((ComponentContainer)vl);
        this.reportParametersPanel.setScrollable(true);
    }

    private void initReportParameters() {
        this.reportParametersPanel.removeAllComponents();
        if (this.report != null) {
            try {
                this.parametersComponent = new ReportParametersComponent(this.report.getContent() != null ? this.report.getContent() : "", this.report.getId(), XmlReportConfigLoader.getInstance().xmlAsParameters(this.cyclicReport.getParametersXml() != null ? this.cyclicReport.getParametersXml() : ""), false, true, false);
                this.reportParametersPanel.addComponent((Component)new TPTLazyLoadingLayout((TPTLazyLoadingLayout.LazyLoader)this.parametersComponent, true));
            }
            catch (Exception e) {
                ExceptionUtils.logSevereException((Exception)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"exception.gui.error"));
                throw new RuntimeException(e);
            }
        }
        this.reportParametersPanel.setVisible(this.report != null);
        this.saveButton.setEnabled(this.report != null);
        this.downloadButton.setEnabled(this.report != null);
    }

    private Component getButtonsPanel() {
        this.saveButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadFormatSelect.setImmediate(true);
        this.downloadFormatSelect.setNullSelectionAllowed(false);
        this.downloadFormatSelect.setWidth(6.0f, 3);
        this.downloadFormatSelect.setFilteringMode(2);
        return new SimpleHorizontalLayout(new Component[]{this.saveButton, this.cancelButton, this.downloadFormatSelect, this.downloadButton});
    }

    private boolean validateParameters() {
        return this.parametersComponent.validateForm();
    }

    private boolean validate() {
        return this.report != null && this.cronExpressionField.getValue() != null && this.cronExpressionField.isValid() && StringUtils.isNotEmpty((String)((String)this.descriptionField.getValue())) && this.outputFormatSelect.getValue() != null && StringUtils.isNotEmpty((String)((String)this.emailField.getValue())) && this.validateParameters();
    }

    private void updateReportData() {
        this.cyclicReport.setCronSpec(this.cronExpressionField.getValue().toString());
        this.cyclicReport.setDescription(this.descriptionField.getValue().toString());
        this.cyclicReport.setEnabled((Boolean)this.enabledCheckBox.getValue());
        this.cyclicReport.setOutputFormat(this.outputFormatSelect.getValue().toString());
        this.cyclicReport.setParametersXml(XmlReportConfigLoader.getInstance().mapAsXml(this.parametersComponent.collectParametersValues()));
        this.cyclicReport.setRecipientEmail(this.emailField.getValue().toString());
        this.cyclicReport.setReport(this.report);
    }

    public CyclicReportOrder getCyclicReportOrder() {
        return this.cyclicReport;
    }

    public abstract void onConfirm();

    public abstract void onCancel();

    static /* synthetic */ ReportTemplate access$002(CyclicReportDetailsComponent x0, ReportTemplate x1) {
        x0.report = x1;
        return x0.report;
    }

    static /* synthetic */ Select access$100(CyclicReportDetailsComponent x0) {
        return x0.reportSelect;
    }

    static /* synthetic */ void access$200(CyclicReportDetailsComponent x0) {
        x0.initReportParameters();
    }

    static /* synthetic */ void access$300(CyclicReportDetailsComponent x0) {
        x0.initOtherReportData();
    }

    static /* synthetic */ TextField access$400(CyclicReportDetailsComponent x0) {
        return x0.cronExpressionField;
    }

    static /* synthetic */ boolean access$500(CyclicReportDetailsComponent x0) {
        return x0.validate();
    }

    static /* synthetic */ void access$600(CyclicReportDetailsComponent x0) {
        x0.updateReportData();
    }

    static /* synthetic */ ReportTemplate access$000(CyclicReportDetailsComponent x0) {
        return x0.report;
    }

    static /* synthetic */ boolean access$700(CyclicReportDetailsComponent x0) {
        return x0.validateParameters();
    }

    static /* synthetic */ Select access$800(CyclicReportDetailsComponent x0) {
        return x0.downloadFormatSelect;
    }

    static /* synthetic */ ReportParametersComponent access$900(CyclicReportDetailsComponent x0) {
        return x0.parametersComponent;
    }
}

