/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard.cyclic;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import eu.livotov.tpt.gui.widgets.TPTLazyLoadingLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apertereports.backbone.scheduler.CyclicReportOrderScheduler;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.components.HelpLayout;
import org.apertereports.components.HelpWindow;
import org.apertereports.components.SimpleHorizontalLayout;
import org.apertereports.dao.CyclicReportOrderDAO;
import org.apertereports.dashboard.cyclic.CyclicReportBrowserComponent;
import org.apertereports.model.CyclicReportOrder;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;

public class CyclicReportsPanel
extends CustomComponent {
    private Map<Integer, CyclicReportOrder> reportOrderMap = new HashMap();
    private Panel mainPanel = new Panel();
    private CyclicReportBrowserComponent browserComponent;
    private Button saveButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.save"));
    private Button cancelButton = new Button(VaadinUtil.getValue((String)"dashboard.edit.cancel"));
    private Button addButton = new Button(VaadinUtil.getValue((String)"cyclic.report.add"));
    private VerticalLayout detailsPanel = new VerticalLayout();
    private VerticalLayout browserPanel = new VerticalLayout();

    public CyclicReportsPanel() {
        this.initView();
        this.initData();
        this.setCompositionRoot((Component)this.mainPanel);
    }

    private void initView() {
        this.mainPanel.setScrollable(true);
        this.mainPanel.setStyleName("borderless light");
        this.mainPanel.setSizeUndefined();
        HelpLayout helpLayout = new HelpLayout(HelpWindow.Module.DASHBOARD, HelpWindow.Tab.CYCLIC_REPORTS);
        this.mainPanel.addComponent((Component)helpLayout);
        this.mainPanel.addComponent((Component)this.browserPanel);
        this.mainPanel.addComponent((Component)this.detailsPanel);
        SimpleHorizontalLayout panel = new SimpleHorizontalLayout(new Component[]{this.saveButton, this.cancelButton, this.addButton});
        this.browserPanel.addComponent((Component)panel);
        this.saveButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addButton.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createDetailsPanel(null);
    }

    private void checkAndRegisterCyclicReport() {
        try {
            ArrayList<Integer> errorOrders = new ArrayList<Integer>();
            Collection reportOrders = this.browserComponent.getCyclicReportOrders();
            for (CyclicReportOrder cro : reportOrders) {
                if (CronExpression.isValidExpression((String)cro.getCronSpec())) continue;
                errorOrders.add(cro.getComponentId());
            }
            if (!errorOrders.isEmpty()) {
                StringBuilder sb = new StringBuilder().append(errorOrders.get(0));
                for (int i = 1; i < errorOrders.size(); ++i) {
                    sb.append(", ").append(errorOrders.get(i));
                }
                NotificationUtil.validationErrors((Window)this.getWindow(), (String)(VaadinUtil.getValue((String)"cyclic.report.cron.validation.error") + " " + sb.toString()));
                return;
            }
            Collection deletedCyclicReports = CyclicReportOrderDAO.trimAndUpdate((Collection)reportOrders);
            for (CyclicReportOrder cro : deletedCyclicReports) {
                CyclicReportOrderScheduler.unscheduleCyclicReportOrder((CyclicReportOrder)cro);
            }
            for (CyclicReportOrder cro : reportOrders) {
                CyclicReportOrderScheduler.rescheduleCyclicReportOrder((CyclicReportOrder)cro);
            }
            this.onConfirm();
        }
        catch (SchedulerException e) {
            ExceptionUtils.logSevereException((Exception)((Object)e));
            NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"exception.gui.error"));
            throw new RuntimeException(e);
        }
    }

    public void onConfirm() {
        NotificationUtil.showSavedNotification((Window)this.getWindow());
    }

    public void onCancel() {
        NotificationUtil.showCancelledNotification((Window)this.getWindow());
    }

    private void clearAll() {
        this.browserComponent.clearSelection();
        this.createDetailsPanel(null);
    }

    private void createDetailsPanel(CyclicReportOrder item) {
        this.detailsPanel.removeAllComponents();
        this.detailsPanel.addComponent((Component)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initData() {
        int i = 0;
        Collection reportOrders = CyclicReportOrderDAO.fetchAllEnabledCyclicReports();
        for (CyclicReportOrder reportOrder : reportOrders) {
            reportOrder.setComponentId(Integer.valueOf(i++));
            this.reportOrderMap.put(reportOrder.getComponentId(), reportOrder);
        }
        if (this.browserComponent != null && this.browserPanel.getComponentIndex((Component)this.browserComponent) != -1) {
            this.browserPanel.removeComponent((Component)this.browserComponent);
        }
        this.browserComponent = new /* Unavailable Anonymous Inner Class!! */;
        this.browserPanel.addComponentAsFirst((Component)new TPTLazyLoadingLayout((TPTLazyLoadingLayout.LazyLoader)this.browserComponent, true));
    }

    static /* synthetic */ void access$000(CyclicReportsPanel x0) {
        x0.checkAndRegisterCyclicReport();
    }

    static /* synthetic */ void access$100(CyclicReportsPanel x0) {
        x0.clearAll();
    }

    static /* synthetic */ Map access$200(CyclicReportsPanel x0) {
        return x0.reportOrderMap;
    }

    static /* synthetic */ CyclicReportBrowserComponent access$300(CyclicReportsPanel x0) {
        return x0.browserComponent;
    }

    static /* synthetic */ void access$400(CyclicReportsPanel x0, CyclicReportOrder x1) {
        x0.createDetailsPanel(x1);
    }
}

