/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.generators;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.TextField;
import org.apertereports.generators.ReportBeanFieldFactory;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.VaadinUtil;

public class ReportBeanFieldFactory
extends DefaultFieldFactory {
    private FieldChangeNotifier notifier;
    private ReportTemplate report;
    private Object[] visibleFields;

    public ReportBeanFieldFactory(FieldChangeNotifier notifier, Object[] visibleFields) {
        this.visibleFields = visibleFields;
        this.notifier = notifier;
    }

    public ReportBeanFieldFactory(Object[] visibleFields) {
        this.visibleFields = visibleFields;
    }

    private boolean showField(Object propertyId) {
        for (Object field : this.visibleFields) {
            if (!field.toString().equals(propertyId.toString())) continue;
            return true;
        }
        return false;
    }

    public void setReport(ReportTemplate report) {
        this.report = report;
    }

    public Field createField(Item item, Object propertyId, Component uiContext) {
        CheckBox field = null;
        if (this.showField(propertyId)) {
            if ("active".equals(propertyId)) {
                field = new CheckBox(VaadinUtil.getValue((String)"manager.form.active.label"));
            } else if ("allowOnlineDisplay".equals(propertyId)) {
                field = new CheckBox(VaadinUtil.getValue((String)"manager.form.allowOnlineDisplay.label"));
            } else if ("allowBackgroundOrder".equals(propertyId)) {
                field = new CheckBox(VaadinUtil.getValue((String)"manager.form.allowBackgroundOrder.label"));
            } else if ("filename".equals(propertyId)) {
                TextField filenameField = new TextField("filename");
                filenameField.setCaption(VaadinUtil.getValue((String)"manager.form.filename.label"));
                filenameField.setWidth("100%");
                filenameField.setReadOnly(true);
                field = filenameField;
            } else if ("reportname".equals(propertyId)) {
                TextField nameField = new TextField("reportname");
                nameField.setCaption(VaadinUtil.getValue((String)"manager.form.reportname.label"));
                nameField.setWidth("100%");
                nameField.setReadOnly(true);
                nameField.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
                field = nameField;
            } else if ("description".equals(propertyId)) {
                TextField descriptionField = new TextField("description");
                descriptionField.setRequiredError(VaadinUtil.getValue((String)"manager.form.active.required_error"));
                descriptionField.setRequired(true);
                descriptionField.setCaption(VaadinUtil.getValue((String)"manager.form.description.label"));
                descriptionField.setWidth("100%");
                field = descriptionField;
            }
            if (field != null) {
                if (field instanceof AbstractComponent) {
                    AbstractComponent comp = (AbstractComponent)field;
                    comp.setImmediate(true);
                }
                field.setPropertyDataSource(item.getItemProperty(propertyId));
                CheckBox finalField = field;
                field.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        return field;
    }

    static /* synthetic */ ReportTemplate access$000(ReportBeanFieldFactory x0) {
        return x0.report;
    }

    static /* synthetic */ FieldChangeNotifier access$100(ReportBeanFieldFactory x0) {
        return x0.notifier;
    }
}

