/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.generators;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import eu.livotov.tpt.i18n.TM;
import org.apertereports.common.ReportConstants;
import org.apertereports.model.ReportOrder;
import org.apertereports.util.OnClickOpenMessageInNewWindow;
import org.apertereports.util.VaadinUtil;

public class ReportStatusColumn
extends CustomComponent {
    private ReportOrder reportOrder;
    private Table source;

    public ReportStatusColumn(Table source, ReportOrder reportOrder) {
        this.reportOrder = reportOrder;
        this.source = source;
        this.setCompositionRoot(this.createCompositionRoot());
    }

    private Component createCompositionRoot() {
        if (this.reportOrder == null) {
            return new Label(VaadinUtil.getValue((String)"report_order.table.status.new"));
        }
        if (this.reportOrder.getReportStatus() == ReportOrder.Status.SUCCEEDED) {
            HorizontalLayout hl = new HorizontalLayout();
            hl.setSpacing(true);
            for (ReportConstants.ReportType format : ReportConstants.ReportType.values()) {
                Button formatLink = new Button(format.toString());
                formatLink.setStyleName("link");
                formatLink.addListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                hl.addComponent((Component)formatLink);
            }
            return hl;
        }
        if (this.reportOrder.getReportStatus() == ReportOrder.Status.PROCESSING) {
            return new Label(VaadinUtil.getValue((String)"report_order.table.status.processing"));
        }
        if (this.reportOrder.getReportStatus() == ReportOrder.Status.FAILED) {
            Button label = new Button(VaadinUtil.getValue((String)"report_order.table.status.failed"));
            label.setStyleName("link");
            label.setDescription(this.reportOrder.getErrorDetails());
            label.addListener((Button.ClickListener)new OnClickOpenMessageInNewWindow((Component)this.source, TM.get((String)"report_order.table.status.failed.popup.title", (Object[])new Object[0]), this.reportOrder.getErrorDetails(), 1));
            return label;
        }
        return new Label(VaadinUtil.getValue((String)"report_order.table.status.new"));
    }

    static /* synthetic */ Table access$000(ReportStatusColumn x0) {
        return x0.source;
    }

    static /* synthetic */ ReportOrder access$100(ReportStatusColumn x0) {
        return x0.reportOrder;
    }
}

