/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util.cache;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.util.cache.MapCacheManager;

public class MapCache {
    private String id;
    private Map<String, Object> cache = new HashMap();

    public MapCache() {
        try {
            this.id = this.digest("SHA-1", new String[]{"" + new Random().nextInt(), "" + System.currentTimeMillis(), "" + (new Random().nextInt() << 13), this.toString()});
        }
        catch (NoSuchAlgorithmException e) {
            ExceptionUtils.logSevereException((Exception)e);
            this.id = new Random().nextInt() + "" + System.currentTimeMillis() + (new Random().nextInt() << 13) + this.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheData(String key, long interval, Object data) {
        if (interval == 0L) {
            return;
        }
        Map map = this.cache;
        synchronized (map) {
            this.cache.put(key, data);
        }
        MapCacheManager.objectCached((MapCache)this, (String)key, (long)interval);
    }

    public Object provideData(String key) {
        Object data = this.cache.get(key);
        MapCacheManager.objectProvided((MapCache)this, (String)key);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Map map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateObject(String key) {
        Map map = this.cache;
        synchronized (map) {
            this.cache.remove(key);
        }
    }

    public String getId() {
        return this.id;
    }

    private String digest(String algorithm, String ... chunks) throws NoSuchAlgorithmException {
        MessageDigest m = MessageDigest.getInstance(algorithm);
        for (String add : chunks) {
            if (add == null) continue;
            m.update(add.getBytes());
        }
        String result = new BigInteger(1, m.digest()).toString(16);
        while (result.length() < 32) {
            result = "0" + result;
        }
        return result.toUpperCase();
    }
}

