/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apertereports.util.cache.MapCache;
import org.apertereports.util.cache.MapCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MapCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(MapCacheManager.class);
    private static Thread invalidatingThread = null;
    private static final Map<String, MapCache> cacheMap = new HashMap();
    private static final Map<String, Map<String, IntervalControlBean>> intervalMap = new HashMap();

    private MapCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkCaches(long currentTime) {
        Class<MapCacheManager> clazz = MapCacheManager.class;
        synchronized (MapCacheManager.class) {
            String key;
            Map.Entry entry;
            HashSet<String> nonEmptyCaches = new HashSet<String>();
            Iterator it = intervalMap.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = (String)entry.getKey();
                Map intervals = (Map)entry.getValue();
                if (intervals == null || intervals.isEmpty()) continue;
                Iterator it2 = intervals.entrySet().iterator();
                while (it2.hasNext()) {
                    long elapsedTime;
                    IntervalControlBean ic = (IntervalControlBean)it2.next().getValue();
                    if (ic.getInterval() < 0L || (elapsedTime = currentTime - ic.getCachedTime()) <= ic.getInterval()) continue;
                    MapCache cache = (MapCache)cacheMap.get(key);
                    if (cache != null) {
                        logger.info(MapCacheManager.class.getName() + ": Invalidating object: " + ic.getObjKey() + " from: " + key + " after: " + elapsedTime);
                        cache.invalidateObject(ic.getObjKey());
                        it2.remove();
                        continue;
                    }
                    logger.info(MapCacheManager.class.getName() + ": Removing all intervals after cache mismatch key: " + key);
                    intervals.clear();
                    break;
                }
                if (!intervals.isEmpty()) {
                    nonEmptyCaches.add(key);
                    continue;
                }
                it.remove();
            }
            it = cacheMap.entrySet().iterator();
            while (it.hasNext()) {
                MapCache cache;
                entry = it.next();
                key = (String)entry.getKey();
                if (nonEmptyCaches.contains(key) || (cache = (MapCache)entry.getValue()) == null) continue;
                it.remove();
                cache.clearCache();
                logger.info(MapCacheManager.class.getName() + ": Cleared cache: " + key);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectProvided(MapCache cache, String key) {
        logger.info(MapCacheManager.class.getName() + ": Object provided: " + key + " from: " + cache.getId());
        Class<MapCacheManager> clazz = MapCacheManager.class;
        synchronized (MapCacheManager.class) {
            MapCacheManager.registerCache((MapCache)cache);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectCached(MapCache cache, String key, long interval) {
        logger.info(MapCacheManager.class.getName() + ": Object cached: " + key + " in: " + cache.getId() + " for: " + interval);
        Class<MapCacheManager> clazz = MapCacheManager.class;
        synchronized (MapCacheManager.class) {
            MapCacheManager.registerCache((MapCache)cache);
            HashMap<String, IntervalControlBean> intervals = (HashMap<String, IntervalControlBean>)intervalMap.get(cache.getId());
            if (intervals == null) {
                intervals = new HashMap<String, IntervalControlBean>();
            }
            intervals.put(key, new IntervalControlBean(key, interval, System.currentTimeMillis(), null));
            intervalMap.put(cache.getId(), intervals);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private static void registerCache(MapCache cache) {
        MapCacheManager.init();
        if (!cacheMap.containsKey(cache.getId())) {
            cacheMap.put(cache.getId(), cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAllCaches() {
        logger.info(MapCacheManager.class.getName() + ": Clearing all caches...");
        Class<MapCacheManager> clazz = MapCacheManager.class;
        synchronized (MapCacheManager.class) {
            MapCacheManager.init();
            for (MapCache cache : cacheMap.values()) {
                cache.clearCache();
                logger.info(MapCacheManager.class.getName() + ": Cleared cache: " + cache.getId());
            }
            cacheMap.clear();
            intervalMap.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void init() {
        if (invalidatingThread == null) {
            invalidatingThread = new InvalidatingThread();
            invalidatingThread.start();
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ void access$100(long x0) {
        MapCacheManager.checkCaches((long)x0);
    }

    static /* synthetic */ Thread access$202(Thread x0) {
        invalidatingThread = x0;
        return invalidatingThread;
    }
}

