/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util.wrappers;

import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Select;
import org.apertereports.common.ReportConstants;
import org.apertereports.util.VaadinUtil;
import org.apertereports.util.wrappers.FilterContainer;

public class FieldContainer {
    private Integer order;
    private String name;
    private Component fieldComponent;
    private boolean selectAll;
    private ReportConstants.InputTypes componentType;

    public FieldContainer() {
    }

    public FieldContainer(Integer order, String name, Field field) {
        this.order = order;
        this.name = name;
        this.fieldComponent = field;
    }

    public void addValidator(Validator validator) {
        if (this.fieldComponent != null) {
            if (this.fieldComponent instanceof Field) {
                ((Field)this.fieldComponent).addValidator(validator);
            } else if (this.fieldComponent instanceof FilterContainer) {
                ((FilterContainer)this.fieldComponent).addValidator(validator);
            }
        }
    }

    public ReportConstants.InputTypes getComponentType() {
        return this.componentType;
    }

    public Component getFieldComponent() {
        return this.fieldComponent;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOrder() {
        return this.order;
    }

    public Object getValue() {
        Object value = null;
        if (this.fieldComponent == null) {
            return null;
        }
        if (this.fieldComponent instanceof Field) {
            value = ((Field)this.fieldComponent).getValue();
        } else if (this.fieldComponent instanceof FilterContainer) {
            value = ((FilterContainer)this.fieldComponent).getValue();
        }
        return value;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void placeYourselfInForm(Form form, FormLayout layout) {
        if (this.fieldComponent == null) {
            return;
        }
        if (this.fieldComponent instanceof Field) {
            form.addField((Object)this.name, (Field)this.fieldComponent);
        } else if (this.fieldComponent instanceof FilterContainer) {
            for (Select select : ((FilterContainer)this.fieldComponent).getLevels()) {
                form.addField((Object)select.getCaption(), (Field)select);
            }
        } else {
            layout.addComponent(this.fieldComponent);
        }
        if (this.selectAll) {
            CheckBox saCheckbox = new CheckBox(VaadinUtil.getValue((String)"invoker.form.select_all"));
            saCheckbox.addListener((Property.ValueChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            form.addField((Object)(this.name + "_all"), (Field)saCheckbox);
        }
    }

    public void setComponentType(ReportConstants.InputTypes componentType) {
        this.componentType = componentType;
    }

    public void setFieldComponent(Component field) {
        this.fieldComponent = field;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public void setValue(Object value) {
        if (this.fieldComponent != null) {
            if (this.fieldComponent instanceof Field) {
                Field field = (Field)this.fieldComponent;
                field.setValue(value);
                if (field instanceof Select) {
                    ((Select)this.fieldComponent).select(value);
                }
            } else if (this.fieldComponent instanceof FilterContainer) {
                ((FilterContainer)this.fieldComponent).setValue(value);
            }
        }
    }

    public void validate() {
        block6: {
            try {
                if (this.fieldComponent instanceof Field) {
                    ((Field)this.fieldComponent).validate();
                } else if (this.fieldComponent instanceof FilterContainer) {
                    ((FilterContainer)this.fieldComponent).validate();
                }
            }
            catch (Validator.InvalidValueException e) {
                if (this.fieldComponent instanceof Field) {
                    ((Field)this.fieldComponent).addStyleName("error");
                    ((Field)this.fieldComponent).removeStyleName("error");
                }
                if (!(this.fieldComponent instanceof FilterContainer)) break block6;
                ((FilterContainer)this.fieldComponent).addStyleName("error");
                ((FilterContainer)this.fieldComponent).removeStyleName("error");
            }
        }
    }

    static /* synthetic */ Component access$000(FieldContainer x0) {
        return x0.fieldComponent;
    }
}

