/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports;

import com.liferay.portal.model.Role;
import com.liferay.portal.util.PortalUtil;
import com.vaadin.Application;
import com.vaadin.event.ListenerMethod;
import com.vaadin.terminal.Terminal;
import com.vaadin.terminal.gwt.server.PortletApplicationContext2;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import eu.livotov.tpt.TPTApplication;
import eu.livotov.tpt.i18n.TM;
import java.util.HashSet;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apertereports.common.exception.ARRuntimeException;
import org.apertereports.common.users.User;
import org.apertereports.common.users.UserRole;
import org.apertereports.util.NotificationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportingApplication<T extends Panel>
extends TPTApplication
implements PortletApplicationContext2.PortletListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReportingApplication.class);
    protected Window mainWindow;
    protected T mainPanel;
    private User user;
    private Locale locale;

    public void applicationInit() {
        if (this.getContext() instanceof PortletApplicationContext2) {
            ((PortletApplicationContext2)this.getContext()).removePortletListener((Application)this, (PortletApplicationContext2.PortletListener)this);
            ((PortletApplicationContext2)this.getContext()).addPortletListener((Application)this, (PortletApplicationContext2.PortletListener)this);
        }
        TM.getDictionary().setDefaultLanguage(this.getLocale().getLanguage());
        this.reloadDictionary();
        this.portletInit();
        this.setMainWindow(this.mainWindow);
    }

    public void close() {
        logger.info(" ----------------- CLOSING APPLICATION ------------");
        super.close();
    }

    protected abstract void portletInit();

    protected abstract void reinitUserData(User var1);

    public void firstApplicationStartup() {
    }

    private void reloadDictionary() {
    }

    public void terminalError(Terminal.ErrorEvent event) {
        Throwable throwable = event.getThrowable();
        if (throwable instanceof Exception) {
            Exception e = (Exception)throwable;
            logger.error(e.getMessage(), throwable);
        }
        if (throwable instanceof ListenerMethod.MethodException) {
            throwable = ((ListenerMethod.MethodException)throwable).getCause();
        }
        if (throwable instanceof ARRuntimeException) {
            ARRuntimeException vre = (ARRuntimeException)throwable;
            NotificationUtil.showExceptionNotification((Window)this.getMainWindow(), (ARRuntimeException)vre);
        } else {
            super.terminalError(event);
        }
    }

    public void handleRenderRequest(RenderRequest request, RenderResponse response, Window window) {
        logger.debug("RENDER REQUEST, " + this.getClass().getSimpleName());
        if (this.getContext() instanceof PortletApplicationContext2) {
            try {
                com.liferay.portal.model.User liferayUser = PortalUtil.getUser((PortletRequest)request);
                if (liferayUser != null && (this.user == null || this.user.getLogin().equals(liferayUser.getLogin()))) {
                    String login = liferayUser.getLogin();
                    String email = liferayUser.getEmailAddress();
                    HashSet<UserRole> roles = new HashSet<UserRole>();
                    boolean admin = false;
                    for (Role r : liferayUser.getRoles()) {
                        boolean adminRole = "administrator".equalsIgnoreCase(r.getName());
                        UserRole ur = new UserRole(r.getName(), r.getRoleId(), adminRole);
                        roles.add(ur);
                        admin |= adminRole;
                    }
                    this.user = new User(login, roles, admin, email);
                    this.reinitUserData(this.user);
                }
                if (liferayUser == null && this.user != null) {
                    this.user = null;
                    this.reinitUserData(this.user);
                }
                this.locale = PortalUtil.getLocale((RenderRequest)request);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        logger.debug("RENDER REQUEST END, " + this.getClass().getSimpleName());
    }

    public void handleActionRequest(ActionRequest request, ActionResponse response, Window window) {
    }

    public void handleEventRequest(EventRequest request, EventResponse response, Window window) {
    }

    public void handleResourceRequest(ResourceRequest request, ResourceResponse response, Window window) {
    }

    public User getArUser() {
        return this.user;
    }

    public Locale getArLocale() {
        return this.locale;
    }
}

