/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.event.FieldEvents;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import org.apertereports.backbone.jms.ARJmsFacade;
import org.apertereports.backbone.scheduler.CyclicReportScheduler;
import org.apertereports.common.exception.ARRuntimeException;
import org.apertereports.common.users.User;
import org.apertereports.components.CyclicReportsComponent;
import org.apertereports.components.PaginatedPanelList;
import org.apertereports.model.CyclicReportConfig;
import org.apertereports.ui.UiFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyclicReportsComponent
extends Panel {
    private static final int PAGE_SIZE = 10;
    private static final String COMPONENT_STYLE_NAME = "borderless light";
    private PaginatedPanelList<CyclicReportConfig, CyclicReportPanel> list;
    private static final String DESCRIPTION_STYLE = "small";
    private static final String FORMAT_STYLE = "h4";
    private static final String ORDER_DESCRIPTION = "description";
    private static final String ORDER_CRON_SPEC = "cronSpec";
    private static final String ORDER_RECIPIENT_EMAIL = "recipientEmail";
    private static final String ORDER_OUTPUT_FORMAT = "outputFormat";
    private static final String ORDER_REPORT_REPORTNAME = "reportname";
    private static final String ORDER_REPORT = "report";
    private static final String VALIDATION_EMAIL = "validation.email";
    private static final String VALIDATION_CRON_EXPRESSION = "validation.cronExpression";
    private static final String CYCYLIC_EDIT_REQUIRED_ERROR = "cycylic.edit.required-error.";
    private static final String CYCLIC_EDIT_INPUT_PROMPT = "cyclic.edit.input-prompt.";
    private static final String CYCLIC_EDIT_INPUT_PROMPT_REPORTNAME = "cyclic.edit.input-prompt.reportname";
    private static final String CYCYLIC_EDIT_REQUIRED_ERROR_REPORTNAME = "cycylic.edit.required-error.reportname";
    private static final String CYCLIC_EDIT_INPUT_PROMPT_FORMAT = "cyclic.edit.input-prompt.format";
    private static final String CYCYLIC_EDIT_REQUIRED_ERROR_FORMAT = "cycylic.edit.required-error.format";
    private boolean addingNew = false;
    private Component addOrEditComponent;
    private User user = null;
    private Button addButton;
    private static Logger logger = LoggerFactory.getLogger(CyclicReportsComponent.class);

    public CyclicReportsComponent() {
        this.init();
    }

    public void initData(User user) {
        this.user = user;
        this.addButton.setVisible(user != null);
        this.list.filter(null);
    }

    private void init() {
        HorizontalLayout header = UiFactory.createHLayout((ComponentContainer)this, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_FULL_WIDTH});
        TextField filterField = UiFactory.createSearchBox((String)"label.filter", (ComponentContainer)header, (FieldEvents.TextChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        filterField.setWidth("150px");
        UiFactory.createSpacer((ComponentContainer)header, (String)"10px", null);
        UiFactory.createSpacer((ComponentContainer)header, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_EXPAND_RATIO_1_0});
        this.addButton = UiFactory.createButton((String)"label.add", (ComponentContainer)header, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_INVISIBLE});
        this.list = new /* Unavailable Anonymous Inner Class!! */;
        this.addComponent((Component)this.list);
        this.setStyleName(COMPONENT_STYLE_NAME);
        this.list.filter(null);
        if (!ARJmsFacade.isJmsAvailable()) {
            VerticalLayout footer = UiFactory.createVLayout((ComponentContainer)this, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_FULL_WIDTH});
            UiFactory.createSpacer((ComponentContainer)footer, null, (String)"10px");
            UiFactory.createLabel((String)"JMS unavailable, cyclic reports execution is disabled!", (ComponentContainer)footer);
        }
    }

    private void addNew() {
        if (this.addingNew) {
            return;
        }
        this.addingNew = true;
        this.addButton.setVisible(false);
        CyclicReportConfig order = new CyclicReportConfig();
        VerticalLayout vl = UiFactory.createVLayout(null);
        UiFactory.createSpacer((ComponentContainer)vl, null, (String)"5px");
        EditCyclicReportPanel ecrp = new EditCyclicReportPanel(this, order, true);
        vl.addComponent((Component)ecrp);
        this.addOrEditComponent = vl;
        this.list.addComponent(this.addOrEditComponent, 0);
    }

    private void scheduleOrUnschedule(CyclicReportConfig config) {
        try {
            if (Boolean.TRUE.equals(config.getEnabled())) {
                CyclicReportScheduler.schedule((CyclicReportConfig)config);
            } else {
                CyclicReportScheduler.unschedule((CyclicReportConfig)config);
            }
        }
        catch (SchedulerException e) {
            throw new ARRuntimeException((Exception)((Object)e));
        }
    }

    static /* synthetic */ PaginatedPanelList access$000(CyclicReportsComponent x0) {
        return x0.list;
    }

    static /* synthetic */ void access$100(CyclicReportsComponent x0) {
        x0.addNew();
    }

    static /* synthetic */ User access$200(CyclicReportsComponent x0) {
        return x0.user;
    }

    static /* synthetic */ void access$700(CyclicReportsComponent x0, CyclicReportConfig x1) {
        x0.scheduleOrUnschedule(x1);
    }

    static /* synthetic */ Component access$802(CyclicReportsComponent x0, Component x1) {
        x0.addOrEditComponent = x1;
        return x0.addOrEditComponent;
    }

    static /* synthetic */ Component access$800(CyclicReportsComponent x0) {
        return x0.addOrEditComponent;
    }

    static /* synthetic */ Logger access$1000() {
        return logger;
    }

    static /* synthetic */ boolean access$1102(CyclicReportsComponent x0, boolean x1) {
        x0.addingNew = x1;
        return x0.addingNew;
    }

    static /* synthetic */ Button access$1200(CyclicReportsComponent x0) {
        return x0.addButton;
    }
}

