/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import org.apertereports.ui.UiFactory;

public abstract class PaginatedPanelList<O, W extends Panel>
extends VerticalLayout {
    private String filter;
    private int pageSize;
    private int listSize;
    private int pageNumber;

    public PaginatedPanelList(int pageSize) {
        this.pageSize = pageSize;
    }

    protected abstract Collection<O> fetch(String var1, int var2, int var3);

    protected abstract W transform(O var1);

    protected abstract int getListSize(String var1);

    public void filter(String filter) {
        this.filter = filter;
        this.pageNumber = 0;
        this.refresh(true);
    }

    public void refresh() {
        this.refresh(true);
    }

    private void refresh(boolean getListSize) {
        if (getListSize) {
            this.listSize = this.getListSize(this.filter);
        }
        Collection list = this.fetch(this.filter, this.calculateFirstResult(), this.pageSize);
        this.removeAllComponents();
        for (Object o : list) {
            this.addComponent((Component)this.transform(o));
        }
        if (this.listSize > this.pageSize) {
            this.addFooter();
        }
    }

    private int calculateFirstResult() {
        return this.pageNumber * this.pageSize;
    }

    private void addFooter() {
        HorizontalLayout hl = UiFactory.createHLayout((ComponentContainer)this, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_SPACING});
        hl.setMargin(true, false, false, false);
        if (this.hasPrevious()) {
            UiFactory.createButton((String)"label.previous", (ComponentContainer)hl, (String)"link", (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            UiFactory.createLabel((String)"label.previous", (ComponentContainer)hl);
        }
        for (int i = 0; i < this.countPages(); ++i) {
            int pageIndex = i;
            String caption = "" + (pageIndex + 1);
            if (pageIndex == this.pageNumber) {
                UiFactory.createLabel((String)caption, (ComponentContainer)hl);
                continue;
            }
            UiFactory.createButton((String)caption, (ComponentContainer)hl, (String)"link", (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.hasNext()) {
            UiFactory.createButton((String)"label.next", (ComponentContainer)hl, (String)"link", (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            UiFactory.createLabel((String)"label.next", (ComponentContainer)hl);
        }
    }

    private void showPage(int pageNumber) {
        if (this.hasPage(pageNumber)) {
            this.pageNumber = pageNumber;
            this.refresh(false);
        }
    }

    private void nextPage() {
        if (this.hasNext()) {
            ++this.pageNumber;
        }
        this.refresh(false);
    }

    private void previousPage() {
        if (this.hasPrevious()) {
            --this.pageNumber;
        }
        this.refresh(false);
    }

    private int countPages() {
        int count = this.listSize / this.pageSize + 1;
        if (this.listSize % this.pageSize == 0) {
            --count;
        }
        return count;
    }

    private boolean hasPage(int pageNumber) {
        return pageNumber >= 0 && pageNumber < this.countPages();
    }

    private boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    private boolean hasNext() {
        return this.pageNumber < this.countPages() - 1;
    }

    static /* synthetic */ void access$000(PaginatedPanelList x0) {
        x0.previousPage();
    }

    static /* synthetic */ void access$100(PaginatedPanelList x0, int x1) {
        x0.showPage(x1);
    }

    static /* synthetic */ void access$200(PaginatedPanelList x0) {
        x0.nextPage();
    }
}

