/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.event.FieldEvents;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.Collection;
import java.util.HashSet;
import org.apertereports.common.users.User;
import org.apertereports.components.PaginatedPanelList;
import org.apertereports.components.ReportManagerComponent;
import org.apertereports.dao.CyclicReportConfigDAO;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.model.CyclicReportConfig;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;
import org.apertereports.ui.UiFactory;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReportManagerComponent
extends Panel {
    private static final Logger logger = LoggerFactory.getLogger((String)ReportManagerComponent.class.getName());
    private static final int PAGE_SIZE = 10;
    private static final String DESC_STYLE = "small";
    private static final String CHANGED_DATE_STYLE = "h3";
    private static final String REPORT_NAME_STYLE = "h4";
    private static final String FILE_NAME_STYLE = "h3";
    private static final String EDIT_PANEL_STYLE = "bubble";
    private static final String PANEL_STYLE = "borderless light";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String FILENAME_PROPERTY = "filename";
    private static final String CREATED_PROPERTY = "created";
    private static final String REPORTNAME_PROPERTY = "reportname";
    private static final String ALLOW_BACKGROUND_PROCESSING_PROPERTY = "allowBackgroundProcessing";
    private static final String ALLOW_ONLINE_DISPLAY_PROPERTY = "allowOnlineDisplay";
    private static final String ACTIVE_PROPERTY = "active";
    private static final String REPORT_MANAGER_ITEM_UPLOAD_CHANGE = "report.manager.item.upload.change";
    private static final String REPORT_MANAGER_ITEM_EDIT_NAME_PROMPT = "report.manager.item.edit.name.prompt";
    private static final String REPORT_MANAGER_ITEM_EDIT_BACKGROUND = "report.manager.item.edit.background";
    private static final String REPORT_MANAGER_ITEM_EDIT_ONLINE = "report.manager.item.edit.online";
    private static final String MSG_REMOVING_REPORT = "report.manager.removing.report";
    private static final String MSG_REPORT_IS_USED = "report.manager.report.is.used";
    private static final String MSG_DO_YOU_WANT_TO_CONTINUE = "q.do.you.want.to.continue";
    private PaginatedPanelList<ReportTemplate, ReportItemPanel> list;
    private ReportReceiver newReportReceiver;
    private transient User user;

    public ReportManagerComponent() {
        this.init();
    }

    private void init() {
        VerticalLayout mainLayout = UiFactory.createVLayout((ComponentContainer)this);
        this.newReportReceiver = new ReportReceiver(this, new ReportTemplate());
        this.newReportReceiver.addListener((ReportReceivedListener)new /* Unavailable Anonymous Inner Class!! */);
        Upload newReportUpload = new Upload(null, (Upload.Receiver)this.newReportReceiver);
        newReportUpload.addListener((Upload.SucceededListener)this.newReportReceiver);
        newReportUpload.addListener((Upload.FailedListener)this.newReportReceiver);
        newReportUpload.setButtonCaption(VaadinUtil.getValue((String)"label.add"));
        newReportUpload.setImmediate(true);
        HorizontalLayout hl = UiFactory.createHLayout((ComponentContainer)mainLayout, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_FULL_WIDTH});
        this.list = new /* Unavailable Anonymous Inner Class!! */;
        TextField filterField = UiFactory.createSearchBox((String)"label.filter", (ComponentContainer)hl, (FieldEvents.TextChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        filterField.setWidth("150px");
        hl.addComponent((Component)newReportUpload);
        hl.setComponentAlignment((Component)newReportUpload, Alignment.MIDDLE_RIGHT);
        mainLayout.addComponent((Component)this.list);
        this.setWidth("100%");
        this.setStyleName("borderless light");
    }

    private void addNewReport(ReportTemplate reportTemplate) {
        ReportItemPanel reportItem = new ReportItemPanel(this, reportTemplate);
        this.list.addComponent((Component)reportItem, 0);
        this.addOrEditReport(reportItem, true);
        ReportReceiver.access$302((ReportReceiver)this.newReportReceiver, (ReportTemplate)new ReportTemplate());
    }

    public void initData(User user) {
        this.user = user;
        this.list.filter(null);
    }

    private void addOrEditReport(ReportItemPanel reportItemPanel, boolean adding) {
        AddOrEditReportItemPanel edit = new AddOrEditReportItemPanel(this, reportItemPanel, adding);
        this.list.replaceComponent((Component)reportItemPanel, (Component)edit);
    }

    private void removeReportAndDependants(ReportItemPanel panel, ReportTemplate reportTemplate, Collection<CyclicReportConfig> cyclic, Collection<ReportOrder> orders) {
        if (cyclic != null && !cyclic.isEmpty()) {
            CyclicReportConfigDAO.remove(cyclic);
        }
        if (orders != null && !orders.isEmpty()) {
            ReportOrderDAO.remove(orders);
        }
        ReportTemplateDAO.remove((ReportTemplate)reportTemplate);
        this.list.removeComponent((Component)panel);
    }

    private void remove(ReportItemPanel reportItemPanel) {
        ReportTemplate rt = ReportItemPanel.access$400((ReportItemPanel)reportItemPanel);
        Collection cyclic = CyclicReportConfigDAO.fetchByReportId((User)this.user, (Integer)rt.getId());
        Collection orders = ReportOrderDAO.fetchByReportId((User)this.user, (Integer)rt.getId());
        if (!cyclic.isEmpty()) {
            NotificationUtil.showConfirmWindow((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"report.manager.removing.report", (Object[])new Object[]{rt.getReportname()}), (String)(VaadinUtil.getValue((String)"report.manager.report.is.used") + "</br>" + VaadinUtil.getValue((String)"q.do.you.want.to.continue")), (NotificationUtil.ConfirmListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.removeReportAndDependants(reportItemPanel, rt, cyclic, orders);
        }
    }

    private static void deepCopy(ReportTemplate source, ReportTemplate target) {
        target.setActive(source.getActive());
        target.setAllowBackgroundOrder(source.getAllowBackgroundOrder());
        target.setAllowOnlineDisplay(source.getAllowOnlineDisplay());
        target.setContent(source.getContent());
        target.setCreated(source.getCreated());
        target.setDescription(source.getDescription());
        target.setFilename(source.getFilename());
        target.setId(source.getId());
        target.setReportname(source.getReportname());
        target.setRolesWithAccess(new HashSet(source.getRolesWithAccess()));
    }

    static /* synthetic */ void access$000(ReportManagerComponent x0, ReportTemplate x1) {
        x0.addNewReport(x1);
    }

    static /* synthetic */ User access$100(ReportManagerComponent x0) {
        return x0.user;
    }

    static /* synthetic */ PaginatedPanelList access$200(ReportManagerComponent x0) {
        return x0.list;
    }

    static /* synthetic */ void access$500(ReportTemplate x0, ReportTemplate x1) {
        ReportManagerComponent.deepCopy((ReportTemplate)x0, (ReportTemplate)x1);
    }

    static /* synthetic */ void access$800(ReportManagerComponent x0, ReportItemPanel x1, boolean x2) {
        x0.addOrEditReport(x1, x2);
    }

    static /* synthetic */ void access$1000(ReportManagerComponent x0, ReportItemPanel x1) {
        x0.remove(x1);
    }

    static /* synthetic */ Logger access$1100() {
        return logger;
    }

    static /* synthetic */ void access$1200(ReportManagerComponent x0, ReportItemPanel x1, ReportTemplate x2, Collection x3, Collection x4) {
        x0.removeReportAndDependants(x1, x2, x3, x4);
    }
}

