/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import java.util.Map;
import org.apertereports.backbone.util.ReportTemplateProvider;
import org.apertereports.common.exception.ARException;
import org.apertereports.common.exception.ARRuntimeException;
import org.apertereports.common.xml.config.ReportConfigParameter;
import org.apertereports.components.ReportParametersComponent;
import org.apertereports.engine.ReportMaster;
import org.apertereports.engine.SubreportProvider;
import org.apertereports.model.ReportTemplate;
import org.apertereports.ui.UiFactory;
import org.apertereports.util.VaadinUtil;

public class ReportParamPanel
extends Panel {
    private ReportParametersComponent reportParametersComponent;
    private HorizontalLayout buttons;

    public ReportParamPanel(ReportTemplate reportTemplate, boolean showFormat) {
        this(reportTemplate, showFormat, null);
    }

    public ReportParamPanel(ReportTemplate reportTemplate, boolean showFormat, List<ReportConfigParameter> params) {
        try {
            ReportMaster rm = new ReportMaster(reportTemplate.getContent(), reportTemplate.getId().toString(), (SubreportProvider)new ReportTemplateProvider());
            this.reportParametersComponent = new ReportParametersComponent(rm, showFormat, params);
            VerticalLayout vl = UiFactory.createVLayout((ComponentContainer)this);
            vl.addComponent((Component)this.reportParametersComponent);
            this.buttons = UiFactory.createHLayout((ComponentContainer)vl);
        }
        catch (ARException e) {
            throw new ARRuntimeException(e);
        }
    }

    public ReportParamPanel() {
    }

    public void addButton(Button button) {
        this.buttons.addComponent((Component)button);
    }

    public void addButtons(HorizontalLayout buttons) {
        this.replaceComponent((Component)this.buttons, (Component)buttons);
        this.buttons = buttons;
    }

    public Map<String, String> collectParametersValues() {
        return this.reportParametersComponent.collectParametersValues();
    }

    public String getOuptutFormat() {
        return this.reportParametersComponent.getSelectedFormat();
    }

    public boolean validateForm() {
        if (this.reportParametersComponent == null) {
            this.getWindow().showNotification(VaadinUtil.getValue((String)"notification.fill.in.the.form.correctly"), 2);
            return false;
        }
        boolean result = this.reportParametersComponent.validateForm();
        if (!result) {
            this.getWindow().showNotification(VaadinUtil.getValue((String)"notification.fill.in.the.form.correctly"), 2);
        }
        return result;
    }
}

