/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.components;

import com.vaadin.data.Buffered;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.Select;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Window;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang.StringUtils;
import org.apertereports.AbstractLazyLoaderComponent;
import org.apertereports.AbstractReportingApplication;
import org.apertereports.backbone.util.ReportTemplateProvider;
import org.apertereports.common.ARConstants;
import org.apertereports.common.exception.ARException;
import org.apertereports.common.users.User;
import org.apertereports.common.utils.LocaleUtils;
import org.apertereports.common.utils.TextUtils;
import org.apertereports.common.utils.TimeUtils;
import org.apertereports.common.wrappers.DictionaryItem;
import org.apertereports.common.xml.config.ReportConfigParameter;
import org.apertereports.components.ReportParametersComponent;
import org.apertereports.dao.DictionaryDAO;
import org.apertereports.engine.ReportMaster;
import org.apertereports.engine.ReportParameter;
import org.apertereports.engine.ReportProperty;
import org.apertereports.engine.SubreportProvider;
import org.apertereports.ui.UiFactoryExt;
import org.apertereports.util.ComponentFactory;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;
import org.apertereports.util.wrappers.DictionaryItemsWrapper;
import org.apertereports.util.wrappers.FieldContainer;
import org.apertereports.util.wrappers.FieldProperties;
import org.apertereports.util.wrappers.FilterContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportParametersComponent
extends AbstractLazyLoaderComponent {
    private Form form = new Form();
    private Map<String, FilterContainer> filters;
    private List<FieldContainer> fields = new LinkedList();
    private ComboBox format;
    private ComboBox localeComboBox;
    private ReportMaster reportMaster;
    private String reportSource;
    private Integer cacheId;
    private boolean includeReportFormat = true;
    private boolean readonly = false;
    private boolean includeLocale = true;
    private boolean viewInitialized = false;
    private final List<ReportConfigParameter> params;
    private static Logger logger = LoggerFactory.getLogger(ReportParametersComponent.class);

    public ReportParametersComponent(ReportMaster rm, boolean showFormat, List<ReportConfigParameter> params) throws ARException {
        this.reportMaster = rm;
        this.includeReportFormat = showFormat;
        if (params == null) {
            params = new LinkedList<ReportConfigParameter>();
        }
        this.params = params;
        this.init();
    }

    public Map<String, String> collectParametersValues() {
        HashMap<String, String> parameters = new HashMap<String, String>(this.fields.size());
        for (FieldContainer field : this.fields) {
            Object rawValue;
            if (field.getComponentType().equals((Object)ARConstants.InputTypes.FILTER) || (rawValue = field.getValue()) == null) continue;
            String value = TextUtils.encodeObjectToSQL((Object)rawValue);
            parameters.put(field.getName(), value);
        }
        parameters.put("login", this.getLogin());
        parameters.put("REPORT_LOCALE", this.localeComboBox.getValue() == null ? null : this.localeComboBox.getValue().toString());
        return parameters;
    }

    private String getLogin() {
        String login = "";
        try {
            User user = ((AbstractReportingApplication)this.getApplication()).getArUser();
            if (user == null) {
                return login;
            }
            login = user.getLogin();
        }
        catch (Exception e) {
            logger.warn(VaadinUtil.getValue((String)"liferay.get.login.exception"), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (login.contains("@")) {
            login = login.split("@", 2)[0];
        }
        return login;
    }

    public String getSelectedFormat() {
        return this.format != null ? this.format.getValue().toString() : null;
    }

    public void lazyLoad() throws Exception {
        this.reportMaster = new ReportMaster(this.reportSource, this.cacheId.toString(), (SubreportProvider)new ReportTemplateProvider());
        this.init();
    }

    public boolean validateForm() {
        boolean result = true;
        for (FieldContainer field : this.fields) {
            field.validate();
        }
        try {
            this.form.commit();
        }
        catch (Validator.InvalidValueException e) {
            result = false;
        }
        catch (Buffered.SourceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result = false;
        }
        return result;
    }

    private FieldContainer buildField(ReportParameter param, FieldProperties fieldProperties) {
        try {
            Field field;
            FieldContainer container = new FieldContainer();
            List items = null;
            if (StringUtils.isNotEmpty((String)fieldProperties.getDictQuery())) {
                String login = this.getLogin();
                String dictQuery = fieldProperties.getDictQuery().replaceAll("\\$LOGIN", login);
                items = DictionaryDAO.fetchDictionary((String)dictQuery);
            }
            if (StringUtils.isNotEmpty((String)fieldProperties.getDictItemList())) {
                items = DictionaryDAO.readDictionaryFromString((String)fieldProperties.getDictItemList());
            }
            if ((field = this.buildFieldBaseForInputType(fieldProperties, items = this.executeSpecialDataQueryCode(fieldProperties, items), container)) != null) {
                this.applyAttributes(fieldProperties, container, field);
            }
            if (fieldProperties.getInputType() == ARConstants.InputTypes.FILTERED_SELECT || fieldProperties.getInputType() == ARConstants.InputTypes.FILTER) {
                FilterContainer filterContainer = this.getFilterContainer(fieldProperties.getFilterGroup());
                filterContainer.addFilter((Select)field, fieldProperties.getLevel(), items);
                container.setFieldComponent((Component)filterContainer);
            }
            this.attachSpecialValidators(fieldProperties, container);
            container.setComponentType(fieldProperties.getInputType());
            container.setOrder(fieldProperties.getOrder());
            container.setName(param.getName());
            return container;
        }
        catch (BuildingFailedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void applyAttributes(FieldProperties fieldProperties, FieldContainer container, Field field) {
        container.setFieldComponent((Component)field);
        if (StringUtils.isNotEmpty((String)fieldProperties.getWidth())) {
            field.setWidth(StringUtils.lowerCase((String)fieldProperties.getWidth()));
        }
        container.setSelectAll(fieldProperties.getSelectAll().booleanValue());
        if (fieldProperties.isRequired().booleanValue()) {
            field.setRequired(fieldProperties.isRequired().booleanValue());
            field.setRequiredError(VaadinUtil.getValue((String)fieldProperties.getRequiredError(), (Object[])new Object[]{fieldProperties.getCaption()}));
        }
        if (StringUtils.isNotEmpty((String)fieldProperties.getRegexp())) {
            field.addValidator((Validator)new RegexpValidator(fieldProperties.getRegexp(), VaadinUtil.getValue((String)fieldProperties.getRegexpError(), (Object[])new Object[]{fieldProperties.getCaption(), fieldProperties.getRegexp()})));
        }
        if (StringUtils.isNotEmpty((String)fieldProperties.getMaxchars()) && field instanceof TextField) {
            try {
                ((TextField)field).setMaxLength(Integer.valueOf(fieldProperties.getMaxchars()).intValue());
            }
            catch (NumberFormatException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void attachSpecialValidators(FieldProperties fieldProperties, FieldContainer container) throws BuildingFailedException {
        if (fieldProperties.getSei() != null && StringUtils.isNotEmpty((String)fieldProperties.getSpecialValidationCode())) {
            try {
                fieldProperties.getSe().eval(fieldProperties.getSpecialValidationCode());
                Validator validator = (Validator)fieldProperties.getSei().invokeFunction("specialValidator", container, fieldProperties.getSpecialValidationError());
                container.addValidator(validator);
            }
            catch (ScriptException e) {
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_validation_code.script_exception", (Exception)e);
                logger.error(e.getMessage(), (Throwable)e);
                throw new BuildingFailedException(this, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_validation_code.no_such_method_exception", (Exception)e);
                logger.error(e.getMessage(), (Throwable)e);
                throw new BuildingFailedException(this, (Throwable)e);
            }
        }
    }

    protected Field buildFieldBaseForInputType(FieldProperties fieldProperties, List<DictionaryItem> items, FieldContainer container) throws BuildingFailedException {
        CheckBox field = null;
        switch (3.$SwitchMap$org$apertereports$common$ARConstants$InputTypes[fieldProperties.getInputType().ordinal()]) {
            case 1: {
                field = new CheckBox(fieldProperties.getCaption());
                break;
            }
            case 2: {
                1 dateField = new /* Unavailable Anonymous Inner Class!! */;
                dateField.setDateFormat(TimeUtils.getDefaultDateFormat());
                dateField.setResolution(2);
                field = dateField;
                break;
            }
            case 3: {
                TextArea text = new TextArea(fieldProperties.getCaption());
                text.setRows(3);
                field = text;
                break;
            }
            case 4: 
            case 5: {
                Select select = new Select(fieldProperties.getCaption());
                select.setImmediate(true);
                try {
                    for (DictionaryItem item : items) {
                        select.addItem((Object)item.getCode());
                        select.setItemCaption((Object)item.getCode(), item.getDescription());
                    }
                }
                catch (NullPointerException e) {
                    NotificationUtil.showErrorNotification((Window)this.getWindow(), (String)(VaadinUtil.getValue((String)"invoker.form.no_items_for_exception") + " " + fieldProperties.getCaption()));
                    throw new BuildingFailedException(this, (Throwable)e);
                }
                select.setMultiSelect(fieldProperties.getInputType() == ARConstants.InputTypes.MULTISELECT);
                select.setFilteringMode(2);
                field = select;
                break;
            }
            case 6: 
            case 7: {
                OptionGroup optionGroup = new OptionGroup(fieldProperties.getCaption());
                try {
                    for (DictionaryItem item : items) {
                        optionGroup.addItem((Object)item.getCode());
                        optionGroup.setItemCaption((Object)item.getCode(), item.getDescription());
                    }
                }
                catch (NullPointerException e) {
                    NotificationUtil.showErrorNotification((Window)this.getWindow(), (String)(VaadinUtil.getValue((String)"invoker.form.no_items_for_exception") + " " + fieldProperties.getCaption()));
                    throw new BuildingFailedException(this, (Throwable)e);
                }
                optionGroup.setMultiSelect(fieldProperties.getInputType() == ARConstants.InputTypes.CHECKBOXES);
                field = optionGroup;
                break;
            }
            case 8: 
            case 9: {
                Select filterSelect = new Select(fieldProperties.getCaption());
                filterSelect.setImmediate(true);
                filterSelect.setMultiSelect(fieldProperties.isMultipleChoice().booleanValue());
                field = filterSelect;
                break;
            }
            case 10: {
                Component component;
                if (fieldProperties.getSei() != null && StringUtils.isNotEmpty((String)fieldProperties.getSpecialControlCode())) {
                    try {
                        fieldProperties.getSe().eval(fieldProperties.getSpecialControlCode());
                        fieldProperties.getSei().invokeFunction("specialControl", container, items, fieldProperties.getWidth(), fieldProperties.getMaxchars(), fieldProperties.isRequired(), fieldProperties.getRequiredError(), fieldProperties.getRegexp(), fieldProperties.getRegexpError(), fieldProperties.getCaption());
                    }
                    catch (ScriptException e) {
                        NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_control_code.script_exception", (Exception)e);
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new BuildingFailedException(this, (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_control_code.no_such_method_exception", (Exception)e);
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new BuildingFailedException(this, (Throwable)e);
                    }
                }
                if (!((component = container.getFieldComponent()) instanceof Field)) break;
                field = (Field)component;
                break;
            }
            default: {
                field = new TextField(fieldProperties.getCaption());
            }
        }
        return field;
    }

    public List<DictionaryItem> executeSpecialDataQueryCode(FieldProperties fieldProperties, List<DictionaryItem> items) throws BuildingFailedException {
        if (fieldProperties.getSei() != null && StringUtils.isNotEmpty((String)fieldProperties.getSpecialDataQueryCode())) {
            try {
                DictionaryItemsWrapper itemsWrapper = new DictionaryItemsWrapper();
                fieldProperties.getSe().eval(fieldProperties.getSpecialDataQueryCode());
                fieldProperties.getSei().invokeFunction("specialQuery", itemsWrapper, fieldProperties.getDictQuery());
                items = itemsWrapper.getItems();
            }
            catch (ScriptException e) {
                logger.error(e.getMessage(), (Throwable)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_data_query_code.script_exception", (Exception)e);
                throw new BuildingFailedException(this, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error(e.getMessage(), (Throwable)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)"invoker.form.special_data_query_code.no_such_method_exception", (Exception)e);
                throw new BuildingFailedException(this, (Throwable)e);
            }
        }
        return items;
    }

    private FilterContainer getFilterContainer(String filterId) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (!this.filters.containsKey(filterId)) {
            this.filters.put(filterId, new FilterContainer());
        }
        return (FilterContainer)this.filters.get(filterId);
    }

    private String getValueFromMap(Map<ARConstants.Keys, ReportProperty> props, ARConstants.Keys key, Enum<?>[] inputTypes, String defaultValue) {
        if (props.containsKey(key)) {
            String value = props.get(key).getValue();
            if (inputTypes == null) {
                return value;
            }
            value = StringUtils.upperCase((String)value);
            for (Enum<?> enum1 : inputTypes) {
                if (!enum1.name().equals(value)) continue;
                return value;
            }
        }
        return defaultValue;
    }

    private void init() {
        this.setCompositionRoot((Component)this.form);
        this.form.setReadOnly(this.readonly);
    }

    private void initFieldsFromConfig() {
        block2: for (ReportConfigParameter param : this.params) {
            if (param.getName().equals("REPORT_LOCALE")) {
                if (this.localeComboBox == null) continue;
                Locale locale = LocaleUtils.createLocale((String)param.getValue());
                this.localeComboBox.setValue((Object)locale);
                continue;
            }
            for (FieldContainer field : this.fields) {
                if (!param.getName().equals(field.getName())) continue;
                try {
                    Class fieldType;
                    Field fieldComponent;
                    Field field2 = fieldComponent = field.getFieldComponent() instanceof Field ? (Field)field.getFieldComponent() : null;
                    Class<Date> clazz = fieldComponent == null ? null : (fieldType = fieldComponent.getPropertyDataSource() == null ? null : fieldComponent.getPropertyDataSource().getType());
                    if (ARConstants.InputTypes.DATE.equals((Object)field.getComponentType())) {
                        fieldType = Date.class;
                    } else if (ARConstants.InputTypes.MULTISELECT.equals((Object)field.getComponentType()) || ARConstants.InputTypes.CHECKBOXES.equals((Object)field.getComponentType()) || ARConstants.InputTypes.FILTERED_SELECT.equals((Object)field.getComponentType())) {
                        fieldType = Collection.class;
                    }
                    Object v = TextUtils.encodeSQLToObject(fieldType, (String)param.getValue());
                    field.setValue(v);
                    continue block2;
                }
                catch (ParseException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"exception.gui.error"), (Exception)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void initView() {
        if (this.viewInitialized) {
            return;
        }
        this.viewInitialized = true;
        List parameters = this.reportMaster.getParameters();
        for (ReportParameter param : parameters) {
            Map props = param.getProperties();
            if (props == null || props.isEmpty()) continue;
            FieldProperties fieldProperties = this.parseFieldProperties(param, props);
            FieldContainer container = this.buildField(param, fieldProperties);
            this.fields.add(container);
        }
        Collections.sort(this.fields, new /* Unavailable Anonymous Inner Class!! */);
        FormLayout layout = new FormLayout();
        this.form.setLayout((Layout)layout);
        for (FieldContainer field : this.fields) {
            if (field == null) continue;
            field.placeYourselfInForm(this.form, layout);
        }
        if (this.includeReportFormat) {
            this.format = ComponentFactory.createFormatCombo((ARConstants.ReportType)ARConstants.ReportType.PDF, (String)"label.format");
            this.format.setSizeUndefined();
            this.form.addField((Object)"format", (Field)this.format);
        }
        if (this.includeLocale) {
            this.localeComboBox = UiFactoryExt.createLocaleCombo((String)"label.locale", (Locale)this.getLocale());
            this.form.addField((Object)"REPORT_LOCALE", (Field)this.localeComboBox);
        } else {
            this.form.setDescription(this.readonly ? VaadinUtil.getValue((String)"invoker.form.header.readonly") : VaadinUtil.getValue((String)"invoker.form.header"));
        }
        this.form.setImmediate(true);
        this.form.setValidationVisible(true);
        this.form.setValidationVisibleOnCommit(true);
        this.form.setInvalidCommitted(false);
        this.form.setWriteThrough(false);
    }

    private FieldProperties parseFieldProperties(ReportParameter param, Map<ARConstants.Keys, ReportProperty> props) {
        FieldProperties fieldProperties = new FieldProperties();
        String inputTypeString = this.getValueFromMap(props, ARConstants.Keys.INPUT_TYPE, (Enum[])ARConstants.InputTypes.values(), ARConstants.InputTypes.CHECKBOX.name());
        fieldProperties.setInputType(ARConstants.InputTypes.valueOf((String)StringUtils.upperCase((String)inputTypeString)));
        fieldProperties.setWidth(this.getValueFromMap(props, ARConstants.Keys.WIDTH, null, ""));
        String caption = this.getValueFromMap(props, ARConstants.Keys.LABEL, null, param.getName());
        fieldProperties.setCaption(StringUtils.capitaliseAllWords((String)StringUtils.lowerCase((String)caption)));
        String orderString = this.getValueFromMap(props, ARConstants.Keys.ORDER, null, "1000");
        try {
            fieldProperties.setOrder(Integer.valueOf(orderString));
        }
        catch (NumberFormatException e) {
            fieldProperties.setOrder(Integer.valueOf(1000));
        }
        String requiredString = this.getValueFromMap(props, ARConstants.Keys.REQUIRED, (Enum[])ARConstants.BooleanValues.values(), "false");
        fieldProperties.setRequired(Boolean.valueOf(requiredString));
        fieldProperties.setRequiredError(this.getValueFromMap(props, ARConstants.Keys.REQUIRED_ERROR, null, "form.errors.required"));
        fieldProperties.setRegexp(this.getValueFromMap(props, ARConstants.Keys.REGEXP, null, ""));
        fieldProperties.setRegexpError(this.getValueFromMap(props, ARConstants.Keys.REGEXP_ERROR, null, "form.errors.regexp"));
        fieldProperties.setMaxchars(this.getValueFromMap(props, ARConstants.Keys.MAXCHARS, null, ""));
        String levelString = this.getValueFromMap(props, ARConstants.Keys.LEVEL, null, "1");
        try {
            fieldProperties.setLevel(Integer.valueOf(levelString));
        }
        catch (NumberFormatException e) {
            fieldProperties.setOrder(Integer.valueOf(1));
        }
        fieldProperties.setFilterGroup(this.getValueFromMap(props, ARConstants.Keys.FILTER_GROUP, null, ""));
        String selectAllString = this.getValueFromMap(props, ARConstants.Keys.SELECT_ALL, (Enum[])ARConstants.BooleanValues.values(), "false");
        fieldProperties.setSelectAll(Boolean.valueOf(selectAllString));
        String multipleChoiceString = this.getValueFromMap(props, ARConstants.Keys.MULTIPLE_CHOICE, (Enum[])ARConstants.BooleanValues.values(), "false");
        fieldProperties.setMultipleChoice(Boolean.valueOf(multipleChoiceString));
        fieldProperties.setDictQuery(this.getValueFromMap(props, ARConstants.Keys.DICT_QUERY, null, ""));
        fieldProperties.setDictItemList(this.getValueFromMap(props, ARConstants.Keys.DICT_ITEM_LIST, null, ""));
        String scriptLang = this.getValueFromMap(props, ARConstants.Keys.SCRIPT_LANGUAGE, null, "");
        if (StringUtils.isNotEmpty((String)scriptLang)) {
            ScriptEngine se;
            ScriptEngineManager sem = new ScriptEngineManager();
            try {
                se = sem.getEngineByName(scriptLang);
            }
            catch (NoSuchMethodError e) {
                try {
                    se = sem.getEngineByName(scriptLang);
                }
                catch (NoSuchMethodError e1) {
                    try {
                        se = sem.getEngineByName(scriptLang);
                    }
                    catch (NoSuchMethodError e2) {
                        se = sem.getEngineByName(scriptLang);
                    }
                }
            }
            Invocable sei = (Invocable)((Object)se);
            fieldProperties.setSei(sei);
            fieldProperties.setSe(se);
        }
        fieldProperties.setSpecialControlCode(this.getValueFromMap(props, ARConstants.Keys.SPECIAL_CONTROL_CODE, null, ""));
        fieldProperties.setSpecialValidationCode(this.getValueFromMap(props, ARConstants.Keys.SPECIAL_VALIDATION_CODE, null, ""));
        fieldProperties.setSpecialValidationError(this.getValueFromMap(props, ARConstants.Keys.SPECIAL_VALIDATION_ERROR, null, ""));
        fieldProperties.setSpecialDataQueryCode(this.getValueFromMap(props, ARConstants.Keys.SPECIAL_DATA_QUERY_CODE, null, ""));
        return fieldProperties;
    }

    public void attach() {
        super.attach();
        this.initView();
        this.initFieldsFromConfig();
    }
}

