/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard;

import com.vaadin.data.Item;
import com.vaadin.data.Validator;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.LinkedList;
import org.apertereports.AbstractReportingApplication;
import org.apertereports.common.ARConstants;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.components.ReportParamPanel;
import org.apertereports.dashboard.AbstractDashboardComponent;
import org.apertereports.dashboard.EditDashboardComponentNew;
import org.apertereports.model.ReportTemplate;
import org.apertereports.ui.CloseListener;
import org.apertereports.ui.UiFactory;
import org.apertereports.util.VaadinUtil;

public class EditDashboardComponentNew
extends AbstractDashboardComponent {
    private static final String CACHE_TIMEOUT = "cacheTimeout";
    private static final String REPORT = "report";
    private static final String EXPORT_BUTTONS = "exportButtons";
    private static final String REFRESH_BUTTON = "refreshButton";
    private static final String DASHBOARD_EDIT_CAPTION_CACHE_TIMEOUT = "dashboard.edit.caption.cacheTimeout";
    private static final String DASHBOARD_EDIT_REQUIRED_ERROR_CACHE_TIMEOUT = "dashboard.edit.required-error.cacheTimeout";
    private static final String DASHBOARD_EDIT_INPUT_PROMPT_REPORT_ID = "dashboard.edit.input-prompt.reportId";
    private static final String DASHBOARD_EDIT_REQUIRED_ERROR_REPORT_ID = "dashboard.edit.required-error.reportId";
    private static final String DASHBOARD_EDIT_CAPTION_REPORT_ID = "dashboard.edit.caption.reportId";
    private VerticalLayout paramsParentComponent;
    private ReportParamPanel paramsPanel = new ReportParamPanel();
    private Form form;
    private Item datasource;
    private ReportConfig reportConfig;
    private CloseListener closeListener = null;
    private AbstractReportingApplication app;

    protected void initComponentData() {
        Panel mainPanel = UiFactory.createPanel((String)"label.configuration");
        this.setCompositionRoot((Component)mainPanel);
        this.app = (AbstractReportingApplication)this.getApplication();
        this.paramsParentComponent = UiFactory.createVLayout((ComponentContainer)mainPanel, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_SPACING, UiFactory.FAction.SET_FULL_WIDTH});
        HorizontalLayout reportRow = UiFactory.createHLayout((ComponentContainer)this.paramsParentComponent, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_FULL_WIDTH});
        this.form = new EditDashboardForm(this);
        reportRow.addComponent((Component)this.form);
        this.paramsParentComponent.addComponent((Component)this.paramsPanel);
        this.paramsPanel.setCaption(VaadinUtil.getValue((String)"label.parameters"));
        HorizontalLayout hl = UiFactory.createHLayout((ComponentContainer)this.paramsParentComponent, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_SPACING});
        UiFactory.createButton((String)"label.ok", (ComponentContainer)hl, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        UiFactory.createButton((String)"label.cancel", (ComponentContainer)hl, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCloseListener(CloseListener closeListener) {
        this.closeListener = closeListener;
    }

    private void reloadParams(ReportTemplate template) {
        ReportParamPanel newParamsPanel;
        if (template == null) {
            newParamsPanel = new ReportParamPanel();
            newParamsPanel.setVisible(false);
        } else {
            newParamsPanel = new ReportParamPanel(template, false, this.reportConfig.getParameters());
        }
        newParamsPanel.setCaption(VaadinUtil.getValue((String)"label.parameters"));
        this.paramsParentComponent.replaceComponent((Component)this.paramsPanel, (Component)newParamsPanel);
        this.paramsPanel = newParamsPanel;
    }

    private void saveConfiguration() {
        try {
            this.form.commit();
        }
        catch (Validator.InvalidValueException e) {
            return;
        }
        this.template = "<report idx=\"0\"></report>";
        ReportTemplate report = (ReportTemplate)this.datasource.getItemProperty((Object)REPORT).getValue();
        ReportConfig config = new ReportConfig();
        config.setId(Integer.valueOf(0));
        config.setReportId(report.getId());
        config.setCacheTimeout((Integer)this.datasource.getItemProperty((Object)CACHE_TIMEOUT).getValue());
        config.setAllowRefresh((Boolean)this.datasource.getItemProperty((Object)REFRESH_BUTTON).getValue());
        config.setParameters(XmlReportConfigLoader.getInstance().mapToParameterList(this.paramsPanel.collectParametersValues()));
        boolean addExportButtons = (Boolean)this.datasource.getItemProperty((Object)EXPORT_BUTTONS).getValue();
        String types = null;
        if (addExportButtons) {
            types = ARConstants.ReportType.XLS + "," + ARConstants.ReportType.PDF + "," + ARConstants.ReportType.HTML + "," + ARConstants.ReportType.CSV;
        }
        config.setAllowedFormats(types);
        this.reportConfigs = new LinkedList();
        this.reportConfigs.add(config);
        this.saveData();
    }

    private ReportConfig getCurrentConfig() {
        if (this.reportConfigs == null || this.reportConfigs.isEmpty()) {
            return new ReportConfig();
        }
        return (ReportConfig)this.reportConfigs.get(0);
    }

    static /* synthetic */ ReportParamPanel access$000(EditDashboardComponentNew x0) {
        return x0.paramsPanel;
    }

    static /* synthetic */ void access$100(EditDashboardComponentNew x0) {
        x0.saveConfiguration();
    }

    static /* synthetic */ CloseListener access$200(EditDashboardComponentNew x0) {
        return x0.closeListener;
    }

    static /* synthetic */ ReportConfig access$302(EditDashboardComponentNew x0, ReportConfig x1) {
        x0.reportConfig = x1;
        return x0.reportConfig;
    }

    static /* synthetic */ ReportConfig access$400(EditDashboardComponentNew x0) {
        return x0.getCurrentConfig();
    }

    static /* synthetic */ ReportConfig access$300(EditDashboardComponentNew x0) {
        return x0.reportConfig;
    }

    static /* synthetic */ AbstractReportingApplication access$500(EditDashboardComponentNew x0) {
        return x0.app;
    }

    static /* synthetic */ void access$600(EditDashboardComponentNew x0, ReportTemplate x1) {
        x0.reloadParams(x1);
    }

    static /* synthetic */ Item access$802(EditDashboardComponentNew x0, Item x1) {
        x0.datasource = x1;
        return x0.datasource;
    }

    static /* synthetic */ Item access$800(EditDashboardComponentNew x0) {
        return x0.datasource;
    }
}

