/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard;

import com.vaadin.Application;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.apertereports.AbstractLazyLoaderComponent;
import org.apertereports.AbstractReportingApplication;
import org.apertereports.backbone.util.ReportTemplateProvider;
import org.apertereports.common.ARConstants;
import org.apertereports.common.exception.ARException;
import org.apertereports.common.exception.ARRuntimeException;
import org.apertereports.common.users.User;
import org.apertereports.common.utils.TextUtils;
import org.apertereports.common.utils.TimeUtils;
import org.apertereports.common.wrappers.Pair;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.dao.CyclicReportConfigDAO;
import org.apertereports.dao.ReportTemplateDAO;
import org.apertereports.dao.utils.ConfigurationCache;
import org.apertereports.dashboard.html.HtmlReportBuilder;
import org.apertereports.dashboard.html.ReportDataProvider;
import org.apertereports.engine.ReportMaster;
import org.apertereports.engine.SubreportProvider;
import org.apertereports.model.CyclicReportConfig;
import org.apertereports.model.ReportTemplate;
import org.apertereports.util.DashboardUtil;
import org.apertereports.util.NotificationUtil;
import org.apertereports.util.VaadinUtil;
import org.apertereports.util.cache.MapCache;
import org.apertereports.util.files.TmpDirMgr;
import org.apertereports.util.files.Zipper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportViewComponent
extends AbstractLazyLoaderComponent
implements ReportDataProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)ReportViewComponent.class.getName());
    private static final String AR_DASHBOARD_REPORT_PANEL_STYLE_ID = "ar-dashboard-report-panel";
    private static final String REPORT_DIR = "report";
    private static final String IMAGES_DIR = "images";
    private static final String REPORT_HTML_FILE = "report.html";
    private static final String REPORT_ZIP_FILE = "report.zip";
    private Panel reportPanel = new Panel();
    private Map<Integer, ReportTemplate> reportMap = new HashMap();
    private Map<Integer, ReportConfig> configMap = new HashMap();
    private Map<Long, CyclicReportConfig> cyclicReportMap = new HashMap();
    private String template;
    private MapCache cache;
    private AbstractReportingApplication application;

    public ReportViewComponent(AbstractReportingApplication application, MapCache cache, String template, List<ReportConfig> configs, boolean lazyLoad) {
        this.application = application;
        this.cache = cache;
        this.template = template;
        this.initInternalData(configs);
        this.reportPanel.setSizeFull();
        this.reportPanel.getContent().setSizeUndefined();
        this.reportPanel.getContent().setStyleName(AR_DASHBOARD_REPORT_PANEL_STYLE_ID);
        this.setCompositionRoot((Component)this.reportPanel);
        if (!lazyLoad) {
            this.init();
        }
    }

    private void init() {
        if (this.template != null && !this.template.isEmpty()) {
            HtmlReportBuilder builder = new HtmlReportBuilder((Application)this.application, (ReportDataProvider)this);
            int[] index = new int[]{0};
            DashboardUtil.executeTemplateMatcherWithList((String)this.template, (Pattern)DashboardUtil.REPORT_TAG_PATTERN, (DashboardUtil.MatchHandlerWithList)new /* Unavailable Anonymous Inner Class!! */);
            builder.addHtmlChunk(this.template.substring(index[0]));
            try {
                this.reportPanel.addComponent((Component)builder.createLayout());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                NotificationUtil.showExceptionNotification((Window)this.getWindow(), (String)VaadinUtil.getValue((String)"exception.gui.error"));
                throw new RuntimeException(e);
            }
        }
    }

    public ReportConfig generateDrilldownReportConfig(Map<String, List<String>> params) {
        ReportConfig drillConfig = new ReportConfig();
        List<String> reportNames = params.get("reportName");
        if (reportNames == null || reportNames.isEmpty()) {
            throw new ARRuntimeException(ARConstants.ErrorCode.DRILLDOWN_NOT_FOUND);
        }
        String reportName = reportNames.get(0);
        for (ReportTemplate rt : this.reportMap.values()) {
            if (!rt.getReportname().equals(reportName)) continue;
            drillConfig.setReportId(rt.getId());
            break;
        }
        if (drillConfig.getReportId() == null) {
            ReportTemplate rt;
            Collection reportTemplates = ReportTemplateDAO.fetchByName((User)this.application.getArUser(), (String)reportName);
            if (reportTemplates.isEmpty()) {
                throw new ARRuntimeException(ARConstants.ErrorCode.DRILLDOWN_REPORT_NOT_FOUND);
            }
            rt = (ReportTemplate)reportTemplates.iterator().next();
            drillConfig.setReportId(rt.getId());
        }
        drillConfig.setAllowRefresh(Boolean.valueOf(false));
        drillConfig.setCacheTimeout(Integer.valueOf(0));
        drillConfig.setId(DashboardUtil.generateDrilldownId(this.configMap.keySet()));
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : params.entrySet()) {
            String key = e.getKey();
            List<String> values = e.getValue();
            if (key.equalsIgnoreCase("allowedFormats")) {
                ArrayList<String> allowedFormats = new ArrayList<String>();
                for (String f : values) {
                    String[] splitted = f.split(",");
                    allowedFormats.addAll(Arrays.asList(splitted));
                }
                drillConfig.setAllowedFormatsFromList(allowedFormats);
                continue;
            }
            if (key.equalsIgnoreCase("allowRefresh")) {
                if (values.size() != 1) continue;
                drillConfig.setAllowRefresh(Boolean.valueOf("true".equalsIgnoreCase(values.get(0))));
                continue;
            }
            if (key.equalsIgnoreCase("cacheTimeout")) {
                if (values.size() != 1) continue;
                drillConfig.setCacheTimeout(Integer.valueOf(Integer.parseInt(values.get(0))));
                continue;
            }
            if (values.size() <= 0) continue;
            String paramValue = values.size() == 1 ? TextUtils.encodeObjectToSQL((Object)values.get(0)) : TextUtils.encodeObjectToSQL(values);
            reportParameters.put(key, paramValue);
        }
        drillConfig.setParameters(XmlReportConfigLoader.getInstance().mapToParameterList(reportParameters));
        return drillConfig;
    }

    public ReportTemplate provideReportTemplate(ReportConfig config) {
        if (!this.reportMap.containsKey(config.getReportId())) {
            try {
                ReportTemplate report = ReportTemplateDAO.fetchById((User)this.application.getArUser(), (Integer)config.getReportId());
                if (report != null) {
                    this.reportMap.put(config.getReportId(), report);
                }
            }
            catch (ARException ex) {
                if (ex.getErrorCode() == ARConstants.ErrorCode.REPORT_ACCESS_DENIED) {
                    logger.warn("no permission to report");
                    return null;
                }
                throw new ARRuntimeException(ex);
            }
        }
        return (ReportTemplate)this.reportMap.get(config.getReportId());
    }

    public File provideReportFileForHtmlExport(ReportConfig config, boolean cached) {
        JasperPrint jp = this.getJasperPrint(config, cached);
        TmpDirMgr tmp = new TmpDirMgr();
        File tmpDir = tmp.createNewTmpDir(REPORT_DIR);
        String reportDirPath = tmpDir.getAbsolutePath() + File.separator + REPORT_DIR;
        byte[] data = this.getReportData(jp, ARConstants.ReportType.HTML, reportDirPath);
        File f = new File(reportDirPath + File.separator + REPORT_HTML_FILE);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(data);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw new ARRuntimeException(e);
        }
        File imagesDir = new File(reportDirPath + File.separator + IMAGES_DIR);
        if (!imagesDir.isDirectory()) {
            return f;
        }
        try {
            File zipF = new File(tmpDir.getAbsolutePath() + File.separator + REPORT_ZIP_FILE);
            Zipper.zip((String)reportDirPath, (String)zipF.getAbsolutePath());
            return zipF;
        }
        catch (Exception ex) {
            throw new ARRuntimeException(ex);
        }
    }

    public Pair<JasperPrint, byte[]> provideReportData(ReportConfig config, ARConstants.ReportType format, boolean cached) {
        JasperPrint jp = this.getJasperPrint(config, cached);
        byte[] data = this.getReportData(jp, format, null);
        return new Pair((Object)jp, (Object)data);
    }

    private JasperPrint getJasperPrint(ReportConfig config, boolean cached) {
        try {
            HashMap parameters;
            JasperPrint jp;
            if (cached && (jp = (JasperPrint)this.cache.provideData(config.getId().toString())) != null) {
                return jp;
            }
            ReportTemplate report = this.provideReportTemplate(config);
            if (report == null) {
                throw new ARException(ARConstants.ErrorCode.REPORT_TEMPLATE_NOT_FOUND);
            }
            ReportMaster reportMaster = new ReportMaster(report.getContent(), report.getId().toString(), (SubreportProvider)new ReportTemplateProvider());
            if (config.getCyclicReportId() != null) {
                CyclicReportConfig cro = (CyclicReportConfig)this.cyclicReportMap.get(config.getCyclicReportId());
                parameters = new HashMap(XmlReportConfigLoader.getInstance().xmlAsMap(cro.getParametersXml() != null ? cro.getParametersXml() : ""));
            } else {
                parameters = new HashMap(XmlReportConfigLoader.getInstance().parameterListToMap(config.getParameters()));
            }
            JasperPrint jp2 = reportMaster.generateReport(parameters);
            this.cache.cacheData(config.getId().toString(), TimeUtils.secondsToMilliseconds((int)config.getCacheTimeout()), (Object)jp2);
            return jp2;
        }
        catch (ARException e) {
            throw new ARRuntimeException(e);
        }
    }

    private byte[] getReportData(JasperPrint jasperPrint, ARConstants.ReportType format, String htmlExportDirPath) {
        try {
            HashMap<JRHtmlExporterParameter, Object> customParams = null;
            if (ARConstants.ReportType.HTML.equals((Object)format)) {
                customParams = new HashMap<JRHtmlExporterParameter, Object>();
                customParams.put(JRHtmlExporterParameter.IMAGES_URI, "dashboardimage?image=");
                if (htmlExportDirPath != null) {
                    customParams.put(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, Boolean.TRUE);
                    customParams.put(JRHtmlExporterParameter.IMAGES_DIR_NAME, htmlExportDirPath + File.separator + IMAGES_DIR + File.separator);
                    customParams.put(JRHtmlExporterParameter.IMAGES_URI, IMAGES_DIR + File.separator);
                }
            }
            return ReportMaster.exportReport((JasperPrint)jasperPrint, (String)format.name(), customParams, (Map)ConfigurationCache.getConfiguration());
        }
        catch (ARException e) {
            throw new ARRuntimeException(e);
        }
    }

    private void initInternalData(List<ReportConfig> configs) {
        Set configIds = DashboardUtil.getReportConfigIds((String)this.template);
        if (!configIds.isEmpty() && configs != null && !configs.isEmpty()) {
            HashSet<Integer> reportIds = new HashSet<Integer>();
            HashMap<Long, ReportConfig> cyclicConfigMap = new HashMap<Long, ReportConfig>();
            for (ReportConfig rc : configs) {
                if (!configIds.contains(rc.getId())) continue;
                this.configMap.put(rc.getId(), rc);
                if (rc.getCyclicReportId() != null) {
                    cyclicConfigMap.put(rc.getCyclicReportId(), rc);
                    continue;
                }
                reportIds.add(rc.getReportId());
            }
            Collection cyclicReports = CyclicReportConfigDAO.fetchByIds((Long[])cyclicConfigMap.keySet().toArray(new Long[cyclicConfigMap.keySet().size()]));
            for (CyclicReportConfig rep : cyclicReports) {
                ReportConfig rc = (ReportConfig)cyclicConfigMap.get(rep.getId());
                rc.setReportId(rep.getReport().getId());
                reportIds.add(rep.getReport().getId());
                this.cyclicReportMap.put(rep.getId(), rep);
            }
            Collection reports = ReportTemplateDAO.fetchByIds((Integer[])reportIds.toArray(new Integer[configIds.size()]));
            for (ReportTemplate rep : reports) {
                this.reportMap.put(rep.getId(), rep);
            }
        }
    }

    public void lazyLoad() throws Exception {
        this.init();
    }

    static /* synthetic */ String access$000(ReportViewComponent x0) {
        return x0.template;
    }

    static /* synthetic */ Map access$100(ReportViewComponent x0) {
        return x0.configMap;
    }
}

