/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.dashboard.html;

import com.vaadin.Application;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apertereports.common.ARConstants;
import org.apertereports.common.exception.ARRuntimeException;
import org.apertereports.common.wrappers.Pair;
import org.apertereports.common.xml.config.ReportConfig;
import org.apertereports.dashboard.html.ReportDataProvider;
import org.apertereports.model.ReportTemplate;
import org.apertereports.ui.UiFactory;
import org.apertereports.util.DashboardUtil;
import org.apertereports.util.FileStreamer;
import org.apertereports.util.VaadinUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HtmlReportBuilder.class);
    private static final String BUTTONS_TAG = "buttons";
    private static final String REPORT_TAG = "report";
    private static final String DRILLDOWN_TAG = "drilldown";
    private static final String CHART_TAG = "chart";
    private StringBuffer contentBuffer = new StringBuffer();
    private Map<String, Component> mainComponentMap = new HashMap();
    private Map<String, Map<String, Component>> customComponentMap = new HashMap();
    private ReportDataProvider provider;
    private CustomLayout layout;
    private Application application;

    public HtmlReportBuilder(Application application, ReportDataProvider provider) {
        this.application = application;
        this.provider = provider;
    }

    public CustomLayout createLayout() throws IOException {
        this.layout = new CustomLayout((InputStream)new ByteArrayInputStream(this.contentBuffer.toString().getBytes()));
        for (Map.Entry e : this.mainComponentMap.entrySet()) {
            Map map;
            Component c = (Component)e.getValue();
            this.layout.addComponent(c, (String)e.getKey());
            if (!(c instanceof CustomLayout) || (map = (Map)this.customComponentMap.get(e.getKey())) == null || map.isEmpty()) continue;
            for (Map.Entry ee : map.entrySet()) {
                ((CustomLayout)c).addComponent((Component)ee.getValue(), (String)ee.getKey());
            }
        }
        return this.layout;
    }

    public void addHtmlChunk(String html) {
        this.contentBuffer.append(html);
    }

    public void addReportChunk(ReportConfig config, ReportConfig xlsConfig) {
        HorizontalLayout buttons = this.createReportButtons(config, null, xlsConfig, null);
        String componentKey = BUTTONS_TAG + config.getId();
        this.mainComponentMap.put(componentKey, buttons);
        this.contentBuffer.append(this.createDivAnchor(componentKey));
        CustomLayout reportComponent = this.createReportComponent(config, true);
        componentKey = REPORT_TAG + config.getId();
        this.mainComponentMap.put(componentKey, reportComponent != null ? reportComponent : new Label());
        this.contentBuffer.append(this.createDivAnchor(componentKey));
    }

    private HorizontalLayout createReportButtons(ReportConfig config, ReportConfig parentConfig, ReportConfig xlsConfig, String componentId) {
        HorizontalLayout buttons = UiFactory.createHLayout(null, (UiFactory.FAction[])new UiFactory.FAction[]{UiFactory.FAction.SET_SPACING});
        buttons.setSpacing(true);
        if (parentConfig != null && componentId != null) {
            UiFactory.createButton((String)"dashboard.view.drill.up", (ComponentContainer)buttons, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        List allowedFormats = config.getAllowedFormatsAsList();
        for (String format : allowedFormats) {
            UiFactory.createButton((String)format, (ComponentContainer)buttons, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Boolean.TRUE.equals(config.getAllowRefresh())) {
            UiFactory.createButton((String)"label.refresh", (ComponentContainer)buttons, (Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        boolean first = true;
        Iterator it = buttons.getComponentIterator();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            buttons.setComponentAlignment(c, Alignment.MIDDLE_RIGHT);
            if (!first) continue;
            buttons.setExpandRatio(c, 1.0f);
            first = false;
        }
        buttons.setSizeUndefined();
        buttons.setWidth(100.0f, 8);
        return buttons;
    }

    private void handleExportRequest(ReportConfig config, String format) {
        ARConstants.ReportType reportType = ARConstants.ReportType.valueOf((String)format);
        ReportTemplate report = this.provider.provideReportTemplate(config);
        if (report == null) {
            return;
        }
        if ("HTML".equals(format)) {
            File f = this.provider.provideReportFileForHtmlExport(config, true);
            boolean newWindow = f.getName().endsWith(".html");
            FileStreamer.openFile((Application)this.application, (File)f, (boolean)newWindow);
        } else {
            Pair reportData = this.provider.provideReportData(config, reportType, false);
            if (reportData != null) {
                FileStreamer.showFile((Application)this.application, (String)report.getReportname(), (byte[])((byte[])reportData.getEntry()), (String)reportType.name());
            }
        }
    }

    private void refreshReport(ReportConfig config) {
        CustomLayout reportComponent;
        String componentKey = REPORT_TAG + config.getId();
        Map map = (Map)this.customComponentMap.get(componentKey);
        if (map != null) {
            map.clear();
        }
        if ((reportComponent = this.createReportComponent(config, false)) != null) {
            if (map != null && !map.isEmpty()) {
                for (Map.Entry e : map.entrySet()) {
                    reportComponent.addComponent((Component)e.getValue(), (String)e.getKey());
                }
            }
            Component oldComponent = (Component)this.mainComponentMap.get(componentKey);
            this.mainComponentMap.put(componentKey, reportComponent);
            this.layout.replaceComponent(oldComponent, (Component)reportComponent);
        }
    }

    private CustomLayout createReportComponent(ReportConfig config, boolean cached) {
        Pair reportData;
        try {
            reportData = this.provider.provideReportData(config, ARConstants.ReportType.HTML, cached);
        }
        catch (ARRuntimeException e) {
            try {
                String errorLayout = "<div location=\"errorLabel\"></div>";
                String msg = "<b><span style=\"color:red\">" + VaadinUtil.getValue((String)"dashboard.report.creation.error") + "</span></b>";
                msg = msg + "<br>";
                String errorPrefix = "exception." + e.getErrorCode().name().toLowerCase();
                msg = msg + VaadinUtil.getValue((String)(errorPrefix + ".title"));
                String description = "<br/>" + VaadinUtil.getValue((String)(errorPrefix + ".desc"), (Object[])e.getErrorDetails());
                if (e.getCause() != null && e.getCause().getLocalizedMessage() != null) {
                    description = description + "<br/>" + e.getCause().getLocalizedMessage();
                }
                msg = msg + description;
                Label l = new Label(msg, 5);
                CustomLayout cl = new CustomLayout((InputStream)new ByteArrayInputStream(errorLayout.getBytes()));
                cl.addComponent((Component)l, "errorLabel");
                cl.setSizeUndefined();
                cl.setWidth(100.0f, 8);
                return cl;
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        if (reportData == null) {
            return null;
        }
        JasperPrint jasperPrint = (JasperPrint)reportData.getKey();
        String reportHtml = new String((byte[])reportData.getEntry());
        reportHtml = this.createChartComponents(reportHtml, jasperPrint, config);
        reportHtml = this.createDrilldownComponents(reportHtml, config);
        CustomLayout reportLayout = null;
        try {
            reportLayout = new CustomLayout((InputStream)new ByteArrayInputStream(reportHtml.getBytes()));
            reportLayout.setSizeUndefined();
            reportLayout.setWidth(100.0f, 8);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return reportLayout;
    }

    private String createChartComponents(String reportHtml, JasperPrint jasperPrint, ReportConfig config) {
        StringBuilder builder = new StringBuilder();
        int[] index = new int[]{0};
        DashboardUtil.executeTemplateMatcher((String)reportHtml, (Pattern)DashboardUtil.CHART_TAG_PATTERN, (DashboardUtil.MatchHandler)new /* Unavailable Anonymous Inner Class!! */);
        builder.append(reportHtml.substring(index[0]));
        return builder.toString();
    }

    private void addReportComponent(Component comp, String componentId, ReportConfig config) {
        String reportComponentKey = REPORT_TAG + config.getId();
        HashMap<String, Component> map = (HashMap<String, Component>)this.customComponentMap.get(reportComponentKey);
        if (map == null) {
            map = new HashMap<String, Component>();
        }
        map.put(componentId, comp);
        this.customComponentMap.put(reportComponentKey, map);
    }

    private String createDrilldownComponents(String reportHtml, ReportConfig config) {
        StringBuilder builder = new StringBuilder();
        int[] index = new int[]{0};
        int[] drilldownId = new int[]{0};
        DashboardUtil.executeTemplateMatcher((String)reportHtml, (Pattern)DashboardUtil.DRILLDOWN_TAG_PATTERN, (DashboardUtil.MatchHandler)new /* Unavailable Anonymous Inner Class!! */);
        builder.append(reportHtml.substring(index[0]));
        return builder.toString();
    }

    private void returnFromDrill(ReportConfig childConfig, ReportConfig parentConfig, String componentId) {
        this.customComponentMap.remove(REPORT_TAG + childConfig.getId());
        String componentKey = componentId + REPORT_TAG;
        Component oldComponent = (Component)this.mainComponentMap.get(componentKey);
        Component newComponent = (Component)this.mainComponentMap.get(REPORT_TAG + parentConfig.getId());
        this.layout.replaceComponent(oldComponent, newComponent);
        this.mainComponentMap.remove(componentKey);
        componentKey = componentId + BUTTONS_TAG;
        oldComponent = (Component)this.mainComponentMap.get(componentKey);
        newComponent = (Component)this.mainComponentMap.get(BUTTONS_TAG + parentConfig.getId());
        this.layout.replaceComponent(oldComponent, newComponent);
        this.mainComponentMap.remove(componentKey);
    }

    private void openDrilldown(ReportConfig parentConfig, Map<String, List<String>> params, String componentId) {
        ReportConfig drillConfig = this.provider.generateDrilldownReportConfig(params);
        CustomLayout drillReport = this.createReportComponent(drillConfig, false);
        if (drillReport != null) {
            HorizontalLayout drillButtons = this.createReportButtons(drillConfig, parentConfig, null, componentId);
            Map map = (Map)this.customComponentMap.get(REPORT_TAG + drillConfig.getId());
            if (map != null && !map.isEmpty()) {
                for (Map.Entry e : map.entrySet()) {
                    drillReport.addComponent((Component)e.getValue(), (String)e.getKey());
                }
            }
            String componentKey = componentId + REPORT_TAG;
            this.mainComponentMap.put(componentKey, drillReport);
            componentKey = componentId + BUTTONS_TAG;
            this.mainComponentMap.put(componentKey, drillButtons);
            Component oldComponent = (Component)this.mainComponentMap.get(REPORT_TAG + parentConfig.getId());
            this.layout.replaceComponent(oldComponent, (Component)drillReport);
            oldComponent = (Component)this.mainComponentMap.get(BUTTONS_TAG + parentConfig.getId());
            this.layout.replaceComponent(oldComponent, (Component)drillButtons);
        }
    }

    private StreamResource getJasperImageStreamResource(String imageId, JasperPrint jasperPrint) throws JRException {
        ArrayList<JasperPrint> jasperPrintList = new ArrayList<JasperPrint>();
        jasperPrintList.add(jasperPrint);
        JRPrintImage image = JRHtmlExporter.getImage(jasperPrintList, (String)imageId);
        JRRenderable renderer = image.getRenderer();
        if (renderer.getType() == 1) {
            renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
        }
        String imageMimeType = JRTypeSniffer.getImageMimeType((byte)renderer.getImageType());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(renderer.getImageData());
        StreamResource streamResource = new StreamResource((StreamResource.StreamSource)new /* Unavailable Anonymous Inner Class!! */, imageId, this.application);
        streamResource.setMIMEType(imageMimeType);
        return streamResource;
    }

    private String createDivAnchor(String componentId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div location=\"").append(componentId).append("\"></div>");
        return sb.toString();
    }

    static /* synthetic */ void access$000(HtmlReportBuilder x0, ReportConfig x1, ReportConfig x2, String x3) {
        x0.returnFromDrill(x1, x2, x3);
    }

    static /* synthetic */ void access$100(HtmlReportBuilder x0, ReportConfig x1, String x2) {
        x0.handleExportRequest(x1, x2);
    }

    static /* synthetic */ void access$200(HtmlReportBuilder x0, ReportConfig x1) {
        x0.refreshReport(x1);
    }

    static /* synthetic */ StreamResource access$300(HtmlReportBuilder x0, String x1, JasperPrint x2) throws JRException {
        return x0.getJasperImageStreamResource(x1, x2);
    }

    static /* synthetic */ String access$400(HtmlReportBuilder x0, String x1) {
        return x0.createDivAnchor(x1);
    }

    static /* synthetic */ void access$500(HtmlReportBuilder x0, Component x1, String x2, ReportConfig x3) {
        x0.addReportComponent(x1, x2, x3);
    }

    static /* synthetic */ Logger access$600() {
        return logger;
    }

    static /* synthetic */ Application access$700(HtmlReportBuilder x0) {
        return x0.application;
    }

    static /* synthetic */ void access$800(HtmlReportBuilder x0, ReportConfig x1, Map x2, String x3) {
        x0.openDrilldown(x1, x2, x3);
    }
}

