/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util.files;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmpDirMgr {
    private static final Logger logger = LoggerFactory.getLogger(TmpDirMgr.class);
    private File baseDir;
    private static final int MAX_TRIES_NO = 10;

    public TmpDirMgr() {
        this(System.getProperty("user.home") + File.separator + ".BlueSoft" + File.separator + "tmp");
    }

    public TmpDirMgr(String baseDirPath) {
        this(new File(baseDirPath));
    }

    public TmpDirMgr(File baseDir) {
        boolean created;
        if (!baseDir.exists() && !(created = baseDir.mkdirs())) {
            throw new RuntimeException("error creating base dir: " + baseDir);
        }
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("file " + baseDir.getAbsolutePath() + " is not a directory");
        }
        this.baseDir = baseDir;
    }

    public void clearBaseDir() {
        for (File f : this.baseDir.listFiles()) {
            boolean deleted = f.delete();
            if (deleted) continue;
            logger.warn("error while deleting base dir: " + this.baseDir);
        }
    }

    public File createNewTmpDir() {
        return this.createNewTmpDir(null);
    }

    public File createNewTmpDir(String subdir) {
        int i = 10;
        while (i > 0) {
            String name = "" + System.currentTimeMillis();
            File d = new File(this.baseDir.getAbsolutePath() + File.separator + name);
            if (!d.exists()) {
                File sd;
                boolean created = d.mkdirs();
                if (!created) {
                    throw new RuntimeException("error while creating dir: " + d.getAbsolutePath());
                }
                if (subdir != null && subdir.length() > 0 && !(created = (sd = new File(d.getAbsolutePath() + File.separator + subdir)).mkdir())) {
                    throw new RuntimeException("error while creating dir: " + d.getAbsolutePath());
                }
                return d;
            }
            --i;
            try {
                Thread.sleep(2L);
            }
            catch (Exception e) {
                logger.error("sleep error: ", (Throwable)e);
            }
        }
        throw new RuntimeException("cannot create tmp directory");
    }

    public File getBaseDir() {
        return this.baseDir;
    }
}

