/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.util.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Zipper {
    private static final Logger logger = LoggerFactory.getLogger(Zipper.class);
    private static final int BYTES_IN_1KB = 1024;

    private Zipper() {
    }

    public static void zip(String srcPath, String destPath) throws IOException {
        logger.info("SRC: " + srcPath);
        logger.info("DST: " + destPath);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destPath));
        File f = new File(srcPath);
        if (f.isDirectory()) {
            Zipper.addFolder((File)f, (String)f.getName(), (ZipOutputStream)zos);
        } else {
            Zipper.addFile((File)f, (String)"", (ZipOutputStream)zos);
        }
        zos.flush();
        zos.close();
    }

    private static void addFolder(File f, String zipPath, ZipOutputStream zos) throws IOException {
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("folder File object exected");
        }
        for (File e : f.listFiles()) {
            if (e.isDirectory()) {
                String newZipPath = (zipPath.length() == 0 ? "" : zipPath + File.separator) + e.getName();
                Zipper.addFolder((File)e, (String)newZipPath, (ZipOutputStream)zos);
                continue;
            }
            Zipper.addFile((File)e, (String)zipPath, (ZipOutputStream)zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(File f, String zipPath, ZipOutputStream zos) throws IOException {
        if (f.isDirectory()) {
            throw new IllegalArgumentException("regular file expected");
        }
        logger.debug("adding file: " + f.getAbsolutePath() + " -> " + zipPath);
        FileInputStream in = new FileInputStream(f);
        try {
            int len;
            zos.putNextEntry(new ZipEntry(zipPath + (zipPath.length() == 0 ? "" : File.separator) + f.getName()));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
        }
        finally {
            in.close();
        }
    }
}

