/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.jms;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apertereports.backbone.util.EmailProcessor;
import org.apertereports.backbone.util.ReportOrderProcessor;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.exception.AperteReportsRuntimeException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.dao.utils.ConfigurationCache;
import org.apertereports.model.ReportOrder;

@MessageDriven(mappedName="jms/queue/GenerateReport", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class BackgroundOrderProcessor
implements MessageListener {
    public void onMessage(Message message) {
        ReportOrder reportOrder = null;
        try {
            Long id = message.getLongProperty("reportOrderId");
            reportOrder = ReportOrderDAO.fetchReport((Long)id);
            this.processReport(reportOrder);
            if (reportOrder != null) {
                this.forwardResults(reportOrder);
            }
        }
        catch (Exception e) {
            ExceptionUtils.logSevereException((Exception)e);
            if (reportOrder != null) {
                reportOrder.setReportStatus(ReportOrder.Status.FAILED);
                reportOrder.setErrorDetails(e.getMessage());
                ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
            }
            throw new AperteReportsRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToJMS(ReportOrder reportOrder) throws NamingException, JMSException {
        Connection connection = null;
        Session session = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context envContext = (Context)initCtx.lookup("");
            ConnectionFactory connectionFactory = (ConnectionFactory)envContext.lookup(ConfigurationCache.getValue((String)"jndi.jms.connection_factory"));
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)envContext.lookup(reportOrder.getReplyToQ()));
            Message reportOrderMessage = session.createMessage();
            reportOrderMessage.setIntProperty("reportOrderId", reportOrder.getId().intValue());
            producer.send(reportOrderMessage);
            ExceptionUtils.logDebugMessage((String)("sent to " + reportOrder.getReplyToQ() + ": " + reportOrder.getId()));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    private void forwardResults(ReportOrder reportOrder) throws Exception {
        if (StringUtils.isNotEmpty((String)reportOrder.getRecipientEmail())) {
            ExceptionUtils.logDebugMessage((String)("ReportOrder id: " + reportOrder.getId() + " sending email to: " + reportOrder.getRecipientEmail()));
            try {
                EmailProcessor.getInstance().processEmail(reportOrder);
            }
            catch (Exception e) {
                ExceptionUtils.logWarningException((String)("Unable to send email to: " + reportOrder.getRecipientEmail()), (Exception)e);
                throw e;
            }
        }
        if (StringUtils.isNotEmpty((String)reportOrder.getReplyToQ())) {
            this.addToJMS(reportOrder);
        }
    }

    private void processReport(ReportOrder reportOrder) throws AperteReportsException {
        ReportOrderProcessor.getInstance().processReport(reportOrder);
    }
}

