/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.jms;

import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsRuntimeException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.dao.utils.ConfigurationCache;
import org.apertereports.dao.utils.WHS;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ReportOrderPusher {
    public static void addToJMS(Long id) {
        if (!ReportOrderPusher.isJmsAvailable()) {
            throw new AperteReportsRuntimeException(ReportConstants.ErrorCodes.JMS_UNAVAILABLE);
        }
        Connection connection = null;
        Session session = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context envContext = (Context)initCtx.lookup("");
            ConnectionFactory connectionFactory = (ConnectionFactory)envContext.lookup(ConfigurationCache.getValue((String)"jndi.jms.connection_factory"));
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)envContext.lookup(ConfigurationCache.getValue((String)"jndi.jms.queue.generate_report")));
            Message reportOrderMessage = session.createMessage();
            reportOrderMessage.setIntProperty("reportOrderId", id.intValue());
            producer.send(reportOrderMessage);
            ExceptionUtils.logDebugMessage((String)("reportOrderId: " + id));
        }
        catch (Exception e) {
            throw new AperteReportsRuntimeException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                throw new AperteReportsRuntimeException(e);
            }
        }
    }

    public static ReportOrder buildNewOrder(final ReportTemplate report, Map<String, String> parameters, String format, String recipientEmail, String username, String replyToQ) {
        if (!ReportOrderPusher.isJmsAvailable()) {
            throw new AperteReportsRuntimeException(ReportConstants.ErrorCodes.JMS_UNAVAILABLE);
        }
        final ReportOrder reportOrder = new ReportOrder();
        reportOrder.setParametersXml(XmlReportConfigLoader.getInstance().mapAsXml(parameters));
        reportOrder.setOutputFormat(format);
        reportOrder.setRecipientEmail(recipientEmail);
        reportOrder.setUsername(username);
        reportOrder.setReport(report);
        reportOrder.setReplyToQ(replyToQ);
        Boolean alreadyExists = (Boolean)new WHS<Boolean>(){

            public Boolean lambda() {
                return !this.sess.createCriteria(ReportOrder.class).add((Criterion)Restrictions.eq((String)"report", (Object)report)).add((Criterion)Restrictions.eq((String)"parametersXml", (Object)reportOrder.getParametersXml())).add((Criterion)Restrictions.eq((String)"outputFormat", (Object)reportOrder.getOutputFormat())).add((Criterion)Restrictions.eq((String)"username", (Object)reportOrder.getUsername())).add((Criterion)Restrictions.eq((String)"recipientEmail", (Object)reportOrder.getRecipientEmail())).add((Criterion)Restrictions.eq((String)"replyToQ", (Object)reportOrder.getReplyToQ())).add(Restrictions.isNull((String)"reportResult")).list().isEmpty();
            }
        }.p();
        if (alreadyExists.booleanValue()) {
            return null;
        }
        Long id = ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
        reportOrder.setId(id);
        return reportOrder;
    }

    public static boolean isJmsAvailable() {
        return ConfigurationCache.getValue((String)"jndi.jms.connection_factory") != null;
    }
}

