/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.scheduler;

import java.text.ParseException;
import java.util.Collection;
import java.util.logging.Logger;
import org.apertereports.backbone.scheduler.CyclicReportOrderJob;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.dao.CyclicReportOrderDAO;
import org.apertereports.model.CyclicReportOrder;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.calendar.HolidayCalendar;

public class CyclicReportOrderScheduler {
    private static final Logger logger = Logger.getLogger(CyclicReportOrderScheduler.class.getName());
    private static final String calendarName = "cyclicCalendar";
    static Scheduler sched;

    public static void rescheduleCyclicReportOrder(CyclicReportOrder order) throws SchedulerException {
        CyclicReportOrderScheduler.unscheduleCyclicReportOrder(order);
        CyclicReportOrderScheduler.scheduleCyclicReportOrder(order);
    }

    public static void scheduleCyclicReportOrder(CyclicReportOrder order) throws SchedulerException {
        CronTrigger trigger;
        CyclicReportOrderScheduler.init();
        try {
            trigger = new CronTrigger(order.getId().toString(), CyclicReportOrder.class.toString(), order.getCronSpec());
            trigger.setCalendarName(calendarName);
        }
        catch (ParseException e) {
            throw new SchedulerException((Throwable)e);
        }
        JobDetail jobDetail = new JobDetail(order.getId().toString(), CyclicReportOrder.class.toString(), CyclicReportOrderJob.class);
        sched.scheduleJob(jobDetail, (Trigger)trigger);
        logger.info("New job scheduled: " + jobDetail.getName() + " start at: " + trigger.getStartTime());
    }

    public static void unscheduleCyclicReportOrder(CyclicReportOrder order) throws SchedulerException {
        CyclicReportOrderScheduler.init();
        logger.info("Deleting job by name:" + order.getId().toString());
        sched.deleteJob(order.getId().toString(), CyclicReportOrder.class.toString());
    }

    private static void init() throws SchedulerException {
        if (sched == null) {
            sched = StdSchedulerFactory.getDefaultScheduler();
            sched.addCalendar(calendarName, (Calendar)new HolidayCalendar(), true, true);
            sched.start();
            logger.info("Cyclic report scheduler initialized");
        }
    }

    public static void scanForCyclicReportOrders() {
        logger.info("Scanning for cyclic reports");
        try {
            String[] jobNames;
            CyclicReportOrderScheduler.init();
            for (String jobName : jobNames = sched.getJobNames(CyclicReportOrder.class.toString())) {
                sched.deleteJob(jobName, CyclicReportOrder.class.toString());
            }
            Collection cROs = CyclicReportOrderDAO.fetchAllCyclicReportOrders();
            for (CyclicReportOrder cRO : cROs) {
                CyclicReportOrderScheduler.scheduleCyclicReportOrder(cRO);
            }
        }
        catch (Exception e) {
            ExceptionUtils.logSevereException((Exception)e);
        }
    }

    static {
        CyclicReportOrderScheduler.scanForCyclicReportOrders();
    }
}

