/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.HtmlEmail;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apertereports.backbone.util.ResourceBundleMessageProvider;
import org.apertereports.common.ConfigurationConstants;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.utils.ReportGeneratorUtils;
import org.apertereports.dao.ConfigurationDAO;
import org.apertereports.dao.utils.ConfigurationCache;
import org.apertereports.engine.ReportMaster;
import org.apertereports.model.ConfigurationEntry;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;

public class EmailProcessor
implements ConfigurationConstants {
    private String charset = "UTF-8";
    private static final EmailProcessor instance = new EmailProcessor();
    private VelocityEngine velocityEngine = new VelocityEngine();
    private ResourceBundleMessageProvider messageProvider = null;
    private String mailSessionJndi;
    private String mailSessionUser;
    private String backgroundReportTitleKey;
    private String backgroundReportMessageKey;
    private String messageProviderResource;
    private Integer mailSendDelay;

    public static EmailProcessor getInstance() {
        return instance;
    }

    private EmailProcessor() {
        Collection entries = ConfigurationDAO.loadAll();
        for (ConfigurationEntry entry : entries) {
            if (entry.getKey().equals("message.provider.resource")) {
                this.messageProviderResource = entry.getValue();
                continue;
            }
            if (entry.getKey().equals("message.provider.bgreport.email.title")) {
                this.backgroundReportTitleKey = entry.getValue();
                continue;
            }
            if (entry.getKey().equals("message.provider.bgreport.email.msg")) {
                this.backgroundReportMessageKey = entry.getValue();
                continue;
            }
            if (entry.getKey().equals("jndi.mail.session")) {
                this.mailSessionJndi = entry.getValue();
                continue;
            }
            if (entry.getKey().equals("mail.session.user")) {
                this.mailSessionUser = entry.getValue();
                continue;
            }
            if (!entry.getKey().equals("mail.send.delay")) continue;
            this.mailSendDelay = Integer.valueOf(entry.getValue());
        }
        this.messageProvider = new ResourceBundleMessageProvider(this.messageProviderResource);
        Properties velocityProperties = new Properties();
        velocityProperties.setProperty("input.encoding", "UTF-8");
        velocityProperties.setProperty("output.encoding", "UTF-8");
        velocityProperties.setProperty("resource.loader", "file");
        velocityProperties.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        velocityProperties.setProperty("file.resource.loader.cache", "false");
        velocityProperties.setProperty("file.resource.loader.modificationCheckInterval", "0");
        velocityProperties.setProperty("runtile.log", "velocity.log");
        try {
            this.velocityEngine.init(velocityProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processEmail(ReportOrder reportOrder) throws Exception {
        String[] recipients;
        String senderName;
        if (StringUtils.isEmpty((String)reportOrder.getRecipientEmail())) {
            throw new IllegalStateException("empty email recipient");
        }
        byte[] reportContent = this.getReportContent(reportOrder);
        String title = this.messageProvider.getMessage(this.backgroundReportTitleKey);
        if (StringUtils.isEmpty((String)title)) {
            throw new IllegalStateException("empty email title");
        }
        Session session = null;
        javax.naming.Context envContext = null;
        try {
            InitialContext initCtx = new InitialContext();
            envContext = (javax.naming.Context)initCtx.lookup("");
            session = (Session)envContext.lookup(this.mailSessionJndi);
        }
        catch (NamingException e) {
            ExceptionUtils.logSevereException((Exception)e);
            if (envContext != null) {
                try {
                    session = (Session)envContext.lookup("java:comp/env/" + this.mailSessionJndi);
                }
                catch (NamingException ex) {
                    ExceptionUtils.logSevereException((Exception)ex);
                }
            }
        }
        finally {
            envContext.close();
        }
        if (session == null) {
            throw new AperteReportsException(ReportConstants.ErrorCodes.EMAIL_SESSION_NOT_FOUND, this.mailSessionJndi);
        }
        String finalMessage = this.generateFinalMessage(reportOrder);
        Properties properties = session.getProperties();
        String senderEmail = properties.containsKey("sender.email") ? properties.getProperty("sender.email") : (properties.containsKey("mail.smtp.from") ? properties.getProperty("mail.smtp.from") : (properties.containsKey("mail.smtp.user") ? properties.getProperty("mail.smtp.user") : (properties.containsKey(this.mailSessionUser) ? properties.getProperty(this.mailSessionUser) : null)));
        String string = senderName = properties.containsKey("sender.name") ? properties.getProperty("sender.name") : senderEmail;
        if (senderEmail == null) {
            throw new IllegalStateException("Unable to determine sender's email address!");
        }
        HtmlEmail htmlEmail = new HtmlEmail();
        htmlEmail.setMailSession(session);
        htmlEmail.setFrom(senderEmail, senderName, this.charset);
        htmlEmail.setSubject(title);
        htmlEmail.setHtmlMsg(finalMessage);
        htmlEmail.setCharset(this.charset);
        for (String s : recipients = reportOrder.getRecipientEmail().split(";")) {
            htmlEmail.addTo(s, s, this.charset);
        }
        String contentType = ReportConstants.ReportMimeType.valueOf((String)reportOrder.getOutputFormat()).mimeType();
        htmlEmail.attach(this.getReportOrderDataSource(reportOrder.getReport(), contentType, reportContent), reportOrder.getReport().getReportname(), reportOrder.getReport().getDescription(), "attachment");
        htmlEmail.send();
        if (this.mailSendDelay != null && this.mailSendDelay > 0) {
            Thread.sleep(this.mailSendDelay.intValue());
        }
    }

    private String generateFinalMessage(ReportOrder reportOrder) throws AperteReportsException {
        String messageTemplate = this.messageProvider.getMessage(this.backgroundReportMessageKey);
        if (StringUtils.isEmpty((String)messageTemplate)) {
            throw new IllegalStateException("Unable to find message content for email message");
        }
        VelocityContext c = new VelocityContext();
        c.put("reportOrder", (Object)reportOrder);
        StringWriter w = new StringWriter();
        try {
            this.velocityEngine.evaluate((Context)c, (Writer)w, "velocity_error_log.log", messageTemplate);
        }
        catch (IOException e) {
            throw new AperteReportsException((Throwable)e);
        }
        return w.toString();
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ResourceBundleMessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    public void setMessageProvider(ResourceBundleMessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getReportContent(ReportOrder reportOrder) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(ReportGeneratorUtils.decodeContent((String)reportOrder.getReportResult()));
        try {
            byte[] byArray = ReportMaster.exportReport((JasperPrint)((JasperPrint)JRLoader.loadObject((InputStream)bais)), (String)reportOrder.getOutputFormat(), (Map)ConfigurationCache.getConfiguration());
            return byArray;
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException e) {
                ExceptionUtils.logSevereException((Exception)e);
            }
        }
    }

    private DataSource getReportOrderDataSource(final ReportTemplate report, final String contentType, final byte[] bytes) {
        return new DataSource(){

            public String getContentType() {
                return contentType;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(bytes);
            }

            public String getName() {
                return report.getReportname();
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("Unsupported operation");
            }
        };
    }
}

