/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRSaver;
import org.apertereports.backbone.util.ReportTemplateProvider;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.utils.ReportGeneratorUtils;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.engine.ReportMaster;
import org.apertereports.engine.SubreportProvider;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;

public class ReportOrderProcessor {
    private static final ReportOrderProcessor instance = new ReportOrderProcessor();

    public static ReportOrderProcessor getInstance() {
        return instance;
    }

    public void processReport(ReportOrder reportOrder) throws AperteReportsException {
        reportOrder.setStartDate(Calendar.getInstance());
        reportOrder.setReportStatus(ReportOrder.Status.PROCESSING);
        ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
        ReportTemplate reportTemplate = reportOrder.getReport();
        Map parametersMap = XmlReportConfigLoader.getInstance().xmlAsMap(reportOrder.getParametersXml());
        try {
            ReportMaster reportMaster = new ReportMaster(reportTemplate.getContent(), reportTemplate.getId().toString(), (SubreportProvider)new ReportTemplateProvider());
            JasperPrint jasperPrint = reportMaster.generateReport(new HashMap(parametersMap));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JRSaver.saveObject((Object)jasperPrint, (OutputStream)baos);
            reportOrder.setReportResult(ReportGeneratorUtils.encodeContent((byte[])baos.toByteArray()));
            reportOrder.setFinishDate(Calendar.getInstance());
            reportOrder.setReportStatus(ReportOrder.Status.SUCCEEDED);
            ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
        }
        catch (Exception e) {
            ExceptionUtils.logSevereException((Exception)e);
            throw new AperteReportsException((Throwable)e);
        }
    }
}

