/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ResourceBundleMessageProvider {
    private Map<Locale, ResourceBundle> resourceBundleMap;
    private Locale locale;
    private String resourceName;

    public ResourceBundleMessageProvider(String resourceName) {
        this.resourceName = resourceName;
        this.initialize();
    }

    public String getMessage(String messageKey) {
        return this.getMessage(this.locale != null ? this.locale : Locale.getDefault(), messageKey);
    }

    public String getMessage(Locale messageLocale, String messageKey) {
        ResourceBundle messages = this.resourceBundleMap.get(messageLocale);
        if (messages == null) {
            messages = ResourceBundle.getBundle(this.resourceName, messageLocale);
            this.resourceBundleMap.put(messageLocale, messages);
        }
        return messages.getString(messageKey);
    }

    public final void initialize() {
        this.resourceBundleMap = new HashMap<Locale, ResourceBundle>();
        this.resourceBundleMap.put(Locale.getDefault(), ResourceBundle.getBundle(this.resourceName));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

