/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.util;

import java.util.Map;
import org.apertereports.backbone.jms.AperteReportsJmsFacade;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.dao.utils.WHS;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ReportOrderPusher {
    public static void addToJMS(Long id) {
        AperteReportsJmsFacade.sendOrderToJms(id, "jndi.jms.queue.generate_report");
    }

    public static ReportOrder buildNewOrder(final ReportTemplate report, Map<String, String> parameters, String format, String recipientEmail, String username, String replyToQ) {
        final ReportOrder reportOrder = new ReportOrder();
        reportOrder.setParametersXml(XmlReportConfigLoader.getInstance().mapAsXml(parameters));
        reportOrder.setOutputFormat(format);
        reportOrder.setRecipientEmail(recipientEmail);
        reportOrder.setUsername(username);
        reportOrder.setReport(report);
        reportOrder.setReplyToQ(replyToQ);
        Boolean alreadyExists = (Boolean)new WHS<Boolean>(){

            public Boolean lambda() {
                return !this.sess.createCriteria(ReportOrder.class).add((Criterion)Restrictions.eq((String)"report", (Object)report)).add((Criterion)Restrictions.eq((String)"parametersXml", (Object)reportOrder.getParametersXml())).add((Criterion)Restrictions.eq((String)"outputFormat", (Object)reportOrder.getOutputFormat())).add((Criterion)Restrictions.eq((String)"username", (Object)reportOrder.getUsername())).add((Criterion)Restrictions.eq((String)"recipientEmail", (Object)reportOrder.getRecipientEmail())).add((Criterion)Restrictions.eq((String)"replyToQ", (Object)reportOrder.getReplyToQ())).add(Restrictions.isNull((String)"reportResult")).list().isEmpty();
            }
        }.p();
        if (alreadyExists.booleanValue()) {
            return null;
        }
        Long id = ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
        reportOrder.setId(id);
        return reportOrder;
    }
}

