/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.apertereports.backbone.jms.JmsSubscribersConfig;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsRuntimeException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.dao.utils.ConfigurationCache;

public class AperteReportsJmsFacade {
    private static boolean initialized = false;

    private static void subscribeMessageListeners() throws Exception {
        if (initialized) {
            return;
        }
        Connection connection = null;
        Session session = null;
        try {
            InitialContext initCtx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initCtx.lookup(AperteReportsJmsFacade.getJndiNameFromConfiguration("jndi.jms.connection_factory"));
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            for (MessageListener listener : JmsSubscribersConfig.getMessageListeners().keySet()) {
                String configurationKey = JmsSubscribersConfig.getMessageListeners().get(listener);
                try {
                    String queueJndiName = AperteReportsJmsFacade.getJndiNameFromConfiguration(configurationKey);
                    MessageConsumer consumer = session.createConsumer((Destination)initCtx.lookup(queueJndiName));
                    consumer.setMessageListener(listener);
                }
                catch (Exception e) {
                    ExceptionUtils.logSevereException((String)("Cannot find queue in JNDI: " + configurationKey), (Exception)e);
                }
            }
            connection.start();
            initialized = true;
        }
        catch (Exception e) {
            ExceptionUtils.logWarningException((String)"Cannot initialize JMS context", (Exception)e);
            try {
                if (connection != null) {
                    connection.close();
                }
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception ex) {
                ExceptionUtils.logWarningException((String)"Cannot close JMS connection after error", (Exception)ex);
            }
            throw e;
        }
    }

    private static String getJndiNameFromConfiguration(String configurationKey) {
        String jndiName = ConfigurationCache.getValue((String)configurationKey);
        if (jndiName == null) {
            String defaultJndiName = JmsSubscribersConfig.getDefaultJndiName(configurationKey);
            ExceptionUtils.logDebugMessage((String)("JNDI name not found for key: " + configurationKey + " using default:" + defaultJndiName));
            return defaultJndiName;
        }
        return jndiName;
    }

    public static void sendOrderToJms(Long orderId, String queueName) {
        Connection connection = null;
        Session session = null;
        try {
            AperteReportsJmsFacade.subscribeMessageListeners();
            InitialContext initCtx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initCtx.lookup(AperteReportsJmsFacade.getJndiNameFromConfiguration("jndi.jms.connection_factory"));
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)initCtx.lookup(AperteReportsJmsFacade.getJndiNameFromConfiguration(queueName)));
            Message reportOrderMessage = session.createMessage();
            reportOrderMessage.setIntProperty("reportOrderId", orderId.intValue());
            producer.send(reportOrderMessage);
            ExceptionUtils.logDebugMessage((String)("reportOrderId: " + orderId));
        }
        catch (Exception e) {
            throw new AperteReportsRuntimeException(ReportConstants.ErrorCodes.JMS_UNAVAILABLE, (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                throw new AperteReportsRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJmsAvailable() {
        Connection connection = null;
        Session session = null;
        try {
            InitialContext initCtx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initCtx.lookup(AperteReportsJmsFacade.getJndiNameFromConfiguration("jndi.jms.connection_factory"));
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                ExceptionUtils.logWarningException((String)"Cannot close JMS connection after availability test", (Exception)e);
            }
        }
        return true;
    }
}

