/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.jms;

import java.util.HashMap;
import java.util.Map;
import javax.jms.MessageListener;
import org.apertereports.backbone.jms.listener.BackgroundOrderProcessor;
import org.apertereports.backbone.jms.listener.CyclicOrderResponseProcessor;

public class JmsSubscribersConfig {
    private static boolean initialized;
    private static Map<MessageListener, String> messageListeners;
    private static Map<String, String> defaultJndiNames;

    public static Map<MessageListener, String> getMessageListeners() {
        if (!initialized) {
            JmsSubscribersConfig.readConfiguration();
        }
        return messageListeners;
    }

    private static void readConfiguration() {
        messageListeners.put(BackgroundOrderProcessor.getInstance(), "jndi.jms.queue.generate_report");
        messageListeners.put(CyclicOrderResponseProcessor.getInstance(), "jndi.jms.queue.cyclic_report_order");
        defaultJndiNames.put("jndi.jms.connection_factory", "java:comp/env/jms/ConnectionFactory");
        defaultJndiNames.put("jndi.jms.queue.cyclic_report_order", "java:comp/env/jms/queue/CyclicOrderResponse");
        defaultJndiNames.put("jndi.jms.queue.generate_report", "java:comp/env/jms/queue/GenerateReport");
        initialized = true;
    }

    public static String getDefaultJndiName(String key) {
        if (!initialized) {
            JmsSubscribersConfig.readConfiguration();
        }
        return defaultJndiNames.get(key);
    }

    static {
        messageListeners = new HashMap<MessageListener, String>();
        defaultJndiNames = new HashMap<String, String>();
    }
}

