/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.jms.listener;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apertereports.backbone.jms.AperteReportsJmsFacade;
import org.apertereports.backbone.util.EmailProcessor;
import org.apertereports.backbone.util.ReportOrderProcessor;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.model.ReportOrder;

public class BackgroundOrderProcessor
implements MessageListener {
    private static BackgroundOrderProcessor instance;

    public static synchronized BackgroundOrderProcessor getInstance() {
        if (instance == null) {
            instance = new BackgroundOrderProcessor();
        }
        return instance;
    }

    private BackgroundOrderProcessor() {
    }

    public void onMessage(Message message) {
        block3: {
            ReportOrder reportOrder = null;
            try {
                Long id = message.getLongProperty("reportOrderId");
                reportOrder = ReportOrderDAO.fetchReport((Long)id);
                this.processReport(reportOrder);
                if (reportOrder != null) {
                    this.forwardResults(reportOrder);
                }
            }
            catch (Exception e) {
                ExceptionUtils.logSevereException((Exception)e);
                if (reportOrder == null) break block3;
                reportOrder.setReportStatus(ReportOrder.Status.FAILED);
                reportOrder.setErrorDetails(e.getMessage());
                ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
            }
        }
    }

    private void addToJMS(ReportOrder reportOrder) throws NamingException, JMSException {
        AperteReportsJmsFacade.sendOrderToJms(reportOrder.getId(), reportOrder.getReplyToQ());
    }

    private void forwardResults(ReportOrder reportOrder) throws Exception {
        if (StringUtils.isNotEmpty((String)reportOrder.getRecipientEmail())) {
            ExceptionUtils.logDebugMessage((String)("ReportOrder id: " + reportOrder.getId() + " sending email to: " + reportOrder.getRecipientEmail()));
            try {
                EmailProcessor.getInstance().processEmail(reportOrder);
            }
            catch (Exception e) {
                ExceptionUtils.logWarningException((String)("Unable to send email to: " + reportOrder.getRecipientEmail()), (Exception)e);
                throw e;
            }
        }
        if (StringUtils.isNotEmpty((String)reportOrder.getReplyToQ())) {
            this.addToJMS(reportOrder);
        }
    }

    private void processReport(ReportOrder reportOrder) throws AperteReportsException {
        ReportOrderProcessor.getInstance().processReport(reportOrder);
    }
}

