/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.jms.listener;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.dao.CyclicReportOrderDAO;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.model.CyclicReportOrder;
import org.apertereports.model.ReportOrder;

public class CyclicOrderResponseProcessor
implements MessageListener {
    private static CyclicOrderResponseProcessor instance;

    public static synchronized CyclicOrderResponseProcessor getInstance() {
        if (instance == null) {
            instance = new CyclicOrderResponseProcessor();
        }
        return instance;
    }

    private CyclicOrderResponseProcessor() {
    }

    public void onMessage(Message message) {
        try {
            Long id = message.getLongProperty("reportOrderId");
            ReportOrder reportOrder = ReportOrderDAO.fetchReport((Long)id);
            this.processReport(reportOrder);
        }
        catch (JMSException e) {
            ExceptionUtils.logSevereException((Exception)((Object)e));
        }
    }

    private void processReport(ReportOrder reportOrder) {
        CyclicReportOrder cyclicReportOrder = CyclicReportOrderDAO.fetchForReportOrder((Long)reportOrder.getId());
        if (cyclicReportOrder == null) {
            return;
        }
        cyclicReportOrder.setProcessedOrder(null);
        if (reportOrder.getReportResult() != null) {
            cyclicReportOrder.setReportOrder(reportOrder);
        }
        CyclicReportOrderDAO.saveOrUpdateCyclicReportOrder((CyclicReportOrder)cyclicReportOrder);
    }
}

