/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.scheduler;

import java.util.Map;
import org.apertereports.backbone.util.ReportOrderPusher;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.dao.CyclicReportOrderDAO;
import org.apertereports.model.CyclicReportOrder;
import org.apertereports.model.ReportOrder;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CyclicReportOrderJob
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.processOrder(context.getJobDetail());
    }

    private ReportOrder processOrder(JobDetail details) {
        String instName = details.getName();
        Long reportId = Long.valueOf(instName);
        CyclicReportOrder cRO = CyclicReportOrderDAO.fetchCyclicReportOrder((Long)reportId);
        ReportOrder newOrder = null;
        if (cRO != null && cRO.getProcessedOrder() == null) {
            Map params = XmlReportConfigLoader.getInstance().xmlAsMap(cRO.getParametersXml());
            newOrder = ReportOrderPusher.buildNewOrder(cRO.getReport(), params, cRO.getOutputFormat(), cRO.getRecipientEmail(), null, "jndi.jms.queue.cyclic_report_order");
            cRO.setProcessedOrder(newOrder);
            CyclicReportOrderDAO.saveOrUpdateCyclicReportOrder((CyclicReportOrder)cRO);
            ReportOrderPusher.addToJMS(newOrder.getId());
        }
        return newOrder;
    }
}

