/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.backbone.util;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apertereports.backbone.util.ReportTemplateProvider;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.utils.ExceptionUtils;
import org.apertereports.common.utils.ReportGeneratorUtils;
import org.apertereports.common.xml.config.XmlReportConfigLoader;
import org.apertereports.dao.ReportOrderDAO;
import org.apertereports.dao.utils.ConfigurationCache;
import org.apertereports.engine.ReportMaster;
import org.apertereports.engine.SubreportProvider;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;

public class ReportOrderProcessor {
    private static final ReportOrderProcessor instance = new ReportOrderProcessor();

    public static ReportOrderProcessor getInstance() {
        return instance;
    }

    public void processReport(ReportOrder reportOrder) throws AperteReportsException {
        reportOrder.setStartDate(Calendar.getInstance());
        reportOrder.setReportStatus(ReportOrder.Status.PROCESSING);
        ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
        ReportTemplate reportTemplate = reportOrder.getReport();
        Map parametersMap = XmlReportConfigLoader.getInstance().xmlAsMap(reportOrder.getParametersXml());
        try {
            ReportMaster rm = new ReportMaster(reportTemplate.getContent(), reportTemplate.getId().toString(), (SubreportProvider)new ReportTemplateProvider());
            byte[] reportData = rm.generateAndExportReport(reportOrder.getOutputFormat(), new HashMap(parametersMap), ConfigurationCache.getConfiguration());
            reportOrder.setReportResult(ReportGeneratorUtils.encodeContent((byte[])reportData));
            reportOrder.setFinishDate(Calendar.getInstance());
            reportOrder.setReportStatus(ReportOrder.Status.SUCCEEDED);
            ReportOrderDAO.saveOrUpdateReportOrder((ReportOrder)reportOrder);
        }
        catch (Exception e) {
            ExceptionUtils.logSevereException((Exception)e);
            throw new AperteReportsException((Throwable)e);
        }
    }
}

