/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common;

import java.text.SimpleDateFormat;

public interface ReportConstants {
    public static final String WS_NAMESPACE = "http://bluesoft.net.pl/rnd/apertereports/schemas";
    public static final String WS_REQUEST_LOCAL_PART = "GenerateReportRequest";
    public static final String FILE_PREFIX = "AperteReports_";
    public static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("ddMMyyyy_hhmmss");
    public static final String FIELD_DELIMITER = ";";
    public static final String RECORD_DELIMITER = "\n\r";
    public static final Integer CACHE_MANAGER_CHECK_INTERVAL = 1000;
    public static final String DATETIME_PATTERN = "dd-MM-yyyy HH:mm";
    public static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm");
    public static final String CYCLIC_REPORT_ORDER_RESPONSE_Q = "jms/queue/CyclicOrderResponse";
    public static final String GENERATE_REPORT_Q = "jms/queue/GenerateReport";
    public static final String REPORT_ORDER_ID = "reportOrderId";
    public static final String SUBREPORT_MAP_PARAMETER_NAME = "SUBREPORT_MAP";

    public static enum ReportMimeType {
        CSV("application/csv"),
        HTML("text/html"),
        PDF("application/pdf"),
        XLS("application/vnd.ms-excel");

        private final String mimeType;

        private ReportMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String mimeType() {
            return this.mimeType;
        }
    }

    public static enum ReportType {
        CSV,
        HTML,
        PDF,
        XLS;


        public static String[] stringValues() {
            String[] values = new String[ReportType.values().length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ReportType.values()[i].name();
            }
            return values;
        }
    }

    public static enum Parameter {
        DATASOURCE;

    }

    public static enum Keys {
        INPUT_TYPE,
        DICT_QUERY,
        WIDTH,
        MAXCHARS,
        REQUIRED,
        REQUIRED_ERROR,
        REGEXP,
        REGEXP_ERROR,
        ORDER,
        LABEL,
        SCRIPT_LANGUAGE,
        SPECIAL_CONTROL_CODE,
        SPECIAL_VALIDATION_CODE,
        SPECIAL_VALIDATION_ERROR,
        SPECIAL_DATA_QUERY_CODE,
        LEVEL,
        FILTER_GROUP,
        MULTIPLE_CHOICE,
        SELECT_ALL,
        DICT_ITEM_LIST;

    }

    public static enum InputTypes {
        TEXT,
        DATE,
        TEXTAREA,
        SELECT,
        MULTISELECT,
        RADIOBUTTONS,
        CHECKBOXES,
        CHECKBOX,
        SPECIAL_CONTROL,
        FILTER,
        FILTERED_SELECT;

    }

    public static enum ErrorCodes {
        INVALID_REPORT_TYPE,
        JASPER_REPORTS_EXCEPTION,
        INVALID_EXPORTER_PARAMETER,
        REPORT_SOURCE_EXCEPTION,
        SERIALIZATION_EXCEPTION,
        TECHNICAL_ERROR,
        INVALID_DATASOURCE_TYPE,
        UNKNOWN_PROPERTY_NAME,
        UNSUPPORTED_ENCODING,
        SUBREPORT_NOT_FOUND,
        EMPTY_REPORT_SOURCE,
        DUPLICATE_REPORT_NAME,
        EMAIL_SESSION_NOT_FOUND,
        DRILLDOWN_NOT_FOUND,
        DRILLDOWN_REPORT_NOT_FOUND,
        JMS_UNAVAILABLE;

    }

    public static enum BooleanValues {
        FALSE,
        TRUE;

    }
}

