/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.exception;

import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsException;

public class AperteReportsRuntimeException
extends RuntimeException {
    private ReportConstants.ErrorCodes errorCode = ReportConstants.ErrorCodes.TECHNICAL_ERROR;
    private String[] errorDetails = new String[0];

    public AperteReportsRuntimeException(ReportConstants.ErrorCodes errorCode) {
        this.errorCode = errorCode;
    }

    public AperteReportsRuntimeException(String message, ReportConstants.ErrorCodes errorCode) {
        this.errorCode = errorCode;
        this.errorDetails = new String[]{message};
    }

    public AperteReportsRuntimeException(String message, ReportConstants.ErrorCodes errorCode, Throwable cause) {
        this.errorDetails = new String[]{message};
        this.errorCode = errorCode;
    }

    public AperteReportsRuntimeException(ReportConstants.ErrorCodes errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public AperteReportsRuntimeException(AperteReportsException e) {
        super(e);
        this.errorCode = e.getErrorCode();
        this.errorDetails = e.getErrorDetails();
    }

    public AperteReportsRuntimeException(Exception e) {
        if (e instanceof AperteReportsException) {
            AperteReportsException are = (AperteReportsException)e;
            this.initCause(are);
        } else {
            this.initCause(e);
        }
    }

    public ReportConstants.ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public String[] getErrorDetails() {
        return this.errorDetails;
    }

    public String getLocalizationPrefix() {
        return "exception." + this.errorCode.name().toLowerCase();
    }
}

