/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ClassUtils {
    public static Class<?>[] getClassesFromPackage(String pack) throws ClassNotFoundException {
        ArrayList classes;
        block14: {
            File directory;
            block13: {
                String path;
                classes = new ArrayList();
                directory = null;
                String protocol = null;
                try {
                    ClassLoader cld = Thread.currentThread().getContextClassLoader();
                    if (cld == null) {
                        throw new ClassNotFoundException("Can't get class loader.");
                    }
                    path = pack.replace('.', '/');
                    URL resource = cld.getResource(path);
                    if (resource == null) {
                        throw new ClassNotFoundException("No resource for " + path);
                    }
                    directory = new File(resource.getFile());
                    protocol = resource.getProtocol();
                }
                catch (NullPointerException x) {
                    throw new ClassNotFoundException(pack + " (" + directory + ") does not appear to be a valid package");
                }
                if (!"jar".equals("" + protocol)) break block13;
                JarInputStream jarFile = null;
                try {
                    path = directory.getPath();
                    jarFile = new JarInputStream(new FileInputStream(path.substring(5, path.indexOf("!"))));
                    JarEntry jarEntry = jarFile.getNextJarEntry();
                    while (jarEntry != null) {
                        Class<?> clazz = ClassUtils.extractClassFromJar(pack.replace('.', '/'), jarEntry);
                        if (clazz != null) {
                            classes.add(clazz);
                        }
                        jarEntry = jarFile.getNextJarEntry();
                    }
                    ClassUtils.closeJarFile(jarFile);
                }
                catch (Exception e) {
                    try {
                        throw new ClassNotFoundException(pack + " does not appear to be a valid package", e);
                    }
                    catch (Throwable throwable) {
                        ClassUtils.closeJarFile(jarFile);
                        throw throwable;
                    }
                }
                ClassUtils.closeJarFile(jarFile);
                break block14;
            }
            if (directory.exists()) {
                String[] files;
                for (String file : files = directory.list()) {
                    if (!file.endsWith(".class")) continue;
                    classes.add(Class.forName(pack + '.' + file.substring(0, file.length() - 6)));
                }
            } else {
                throw new ClassNotFoundException(pack + " does not appear to be a valid package");
            }
        }
        return classes.toArray(new Class[0]);
    }

    private static void closeJarFile(JarInputStream jarFile) throws ClassNotFoundException {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Closing jarfile ended with exception " + e);
            }
        }
    }

    private static Class<?> extractClassFromJar(String path, JarEntry jarEntry) throws ClassNotFoundException {
        String className = jarEntry.getName();
        if (className.endsWith(".class") && (className = className.substring(0, className.length() - ".class".length())).startsWith(path)) {
            return Class.forName(className.replace('/', '.'));
        }
        return null;
    }
}

