/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.utils.TimeUtils;

public class TextUtils
implements ReportConstants {
    public static String encodeObjectToSQL(Object rawValue) {
        StringBuffer value = new StringBuffer();
        if (rawValue instanceof String) {
            value.append((String)rawValue);
        } else if (rawValue instanceof Object[]) {
            String sep = "'";
            for (Object val : (Object[])rawValue) {
                if (val.toString().isEmpty()) continue;
                value.append(sep + val + "'");
                sep = ",'";
            }
        } else if (rawValue instanceof Collection) {
            String sep = "'";
            for (Object val : (Collection)rawValue) {
                if (val.toString().isEmpty()) continue;
                value.append(sep + val + "'");
                sep = ",'";
            }
        } else if (rawValue instanceof Date) {
            value.append(TimeUtils.getDateFormatted((Date)rawValue));
        }
        return value.toString();
    }

    private static String trimApostrophes(String input) {
        if (input.startsWith("'") && input.endsWith("'")) {
            return input.substring(input.length() > 1 ? 1 : 0, input.length() - 1);
        }
        return input;
    }

    public static String readTestFileToString(InputStream s) throws IOException {
        StringBuffer ds = new StringBuffer();
        int c = 0;
        while ((c = s.read()) >= 0) {
            ds.append((char)c);
        }
        return ds.toString();
    }

    public static Object encodeSQLToObject(Class<?> type, String value) throws ParseException {
        if (type == null || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return TimeUtils.getDateFormatted(value);
        }
        if (Object[].class.isAssignableFrom(type)) {
            return TextUtils.trimListApostrophes(value);
        }
        if (Collection.class.isAssignableFrom(type)) {
            String[] values = TextUtils.trimListApostrophes(value);
            return Arrays.asList(values);
        }
        return value;
    }

    private static String[] trimListApostrophes(String input) {
        String[] values = input.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = TextUtils.trimApostrophes(values[i]);
        }
        return values;
    }
}

