/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.common.xml.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apertereports.common.xml.config.ReportConfigParameter;

@XStreamAlias(value="reportConfig")
public class ReportConfig
implements Serializable {
    @XStreamAsAttribute
    private Integer id;
    @XStreamAsAttribute
    private Integer reportId;
    @XStreamAsAttribute
    private Integer cacheTimeout;
    @XStreamAsAttribute
    private Long cyclicReportId;
    @XStreamAsAttribute
    private Boolean allowRefresh;
    @XStreamAsAttribute
    private String allowedFormats;
    @XStreamImplicit
    private List<ReportConfigParameter> parameters;

    public ReportConfig() {
    }

    public ReportConfig(Integer id, Integer reportId, Integer cacheTimeout, Long cyclicReportId, Boolean allowRefresh, String allowedFormats, List<ReportConfigParameter> parameters) {
        this.id = id;
        this.reportId = reportId;
        this.cacheTimeout = cacheTimeout;
        this.cyclicReportId = cyclicReportId;
        this.allowRefresh = allowRefresh;
        this.allowedFormats = allowedFormats;
        this.parameters = parameters;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getReportId() {
        return this.reportId;
    }

    public void setReportId(Integer reportId) {
        this.reportId = reportId;
    }

    public Integer getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(Integer cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public Long getCyclicReportId() {
        return this.cyclicReportId;
    }

    public void setCyclicReportId(Long cyclicReportId) {
        this.cyclicReportId = cyclicReportId;
    }

    public Boolean getAllowRefresh() {
        return this.allowRefresh;
    }

    public void setAllowRefresh(Boolean allowRefresh) {
        this.allowRefresh = allowRefresh;
    }

    public List<String> getAllowedFormatsAsList() {
        return this.allowedFormats != null ? Arrays.asList(this.allowedFormats.split(",")) : new ArrayList<String>();
    }

    public String getAllowedFormats() {
        return this.allowedFormats;
    }

    public void setAllowedFormats(String allowedFormats) {
        this.allowedFormats = allowedFormats;
    }

    public void setAllowedFormatsFromList(List<String> allowedFormats) {
        if (allowedFormats != null && !allowedFormats.isEmpty()) {
            StringBuffer sb = new StringBuffer().append(allowedFormats.get(0));
            for (int i = 1; i < allowedFormats.size(); ++i) {
                sb.append(",").append(allowedFormats.get(i));
            }
            this.allowedFormats = sb.toString();
        } else {
            this.allowedFormats = null;
        }
    }

    public List<ReportConfigParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ReportConfigParameter> parameters) {
        this.parameters = parameters;
    }
}

