/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apertereports.model.ReportOrder;
import org.apertereports.model.ReportTemplate;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ar_cyclic_report_config")
public class CyclicReportConfig {
    @Transient
    private Integer componentId;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id", nullable=false, length=10)
    private Long id;
    @Column(name="cron_spec")
    private String cronSpec;
    @Column
    private Boolean enabled;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="parameters_xml")
    private String parametersXml;
    @Column(name="output_format")
    private String outputFormat;
    @Column(name="description")
    private String description;
    @ManyToOne
    @JoinColumn(name="report_id")
    private ReportTemplate report;
    @ManyToOne
    @JoinColumn(name="report_order_id")
    private ReportOrder reportOrder;
    @ManyToOne
    @JoinColumn(name="processed_order_id")
    private ReportOrder processedOrder;
    @Column(name="recipient_email")
    private String recipientEmail;

    public CyclicReportConfig() {
    }

    public CyclicReportConfig(CyclicReportConfig cfg) {
        this.cronSpec = cfg.getCronSpec();
        this.description = cfg.getDescription();
        this.enabled = cfg.getEnabled();
        this.id = cfg.getId();
        this.outputFormat = cfg.getOutputFormat();
        this.parametersXml = cfg.getParametersXml();
        this.processedOrder = cfg.getProcessedOrder();
        this.recipientEmail = cfg.getRecipientEmail();
        this.report = cfg.getReport();
        this.reportOrder = cfg.getReportOrder();
        this.componentId = cfg.getComponentId();
    }

    public Integer getComponentId() {
        return this.componentId;
    }

    public void setComponentId(Integer componentId) {
        this.componentId = componentId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCronSpec() {
        return this.cronSpec;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Long getId() {
        return this.id;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getParametersXml() {
        return this.parametersXml;
    }

    public ReportOrder getProcessedOrder() {
        return this.processedOrder;
    }

    public String getRecipientEmail() {
        return this.recipientEmail;
    }

    public ReportTemplate getReport() {
        return this.report;
    }

    public ReportOrder getReportOrder() {
        return this.reportOrder;
    }

    public void setCronSpec(String cronSpec) {
        this.cronSpec = cronSpec;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setParametersXml(String parametersXml) {
        this.parametersXml = parametersXml;
    }

    public void setProcessedOrder(ReportOrder processedOrder) {
        this.processedOrder = processedOrder;
    }

    public void setRecipientEmail(String recipientEmail) {
        this.recipientEmail = recipientEmail;
    }

    public void setReport(ReportTemplate report) {
        this.report = report;
    }

    public void setReportOrder(ReportOrder reportOrder) {
        this.reportOrder = reportOrder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", id: " + this.id;
    }
}

