/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.model;

import java.util.Calendar;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apertereports.model.ReportTemplate;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ar_report_order")
public class ReportOrder {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @PrimaryKeyJoinColumn
    @Column(name="id", nullable=false, length=10)
    private Long id;
    @Column
    private String username;
    @Column(name="create_date", updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar createDate = Calendar.getInstance();
    @Column(name="start_date")
    private Calendar startDate;
    @Column(name="finish_date")
    private Calendar finishDate;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="parameters_xml")
    @Basic(fetch=FetchType.LAZY)
    private String parametersXml;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="report_result")
    @Basic(fetch=FetchType.LAZY)
    private String reportResult;
    @Column(name="output_format")
    private String outputFormat;
    @Column(name="error_details")
    private String errorDetails;
    @Column(name="recipient_email")
    private String recipientEmail;
    @Column(name="reply_to_jms")
    private Boolean replyToJms;
    @ManyToOne
    @JoinColumn(name="report_id")
    private ReportTemplate report;
    @Enumerated
    @Column(name="report_status")
    private Status reportStatus = Status.NEW;

    public Calendar getCreateDate() {
        return this.createDate;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public Calendar getFinishDate() {
        return this.finishDate;
    }

    public Long getId() {
        return this.id;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getParametersXml() {
        return this.parametersXml;
    }

    public String getRecipientEmail() {
        return this.recipientEmail;
    }

    public Boolean getReplyToJms() {
        return this.replyToJms;
    }

    public ReportTemplate getReport() {
        return this.report;
    }

    public String getReportResult() {
        return this.reportResult;
    }

    public Status getReportStatus() {
        return this.reportStatus;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public String getUsername() {
        return this.username;
    }

    public void setCreateDate(Calendar createDate) {
        this.createDate = createDate;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public void setFinishDate(Calendar finishDate) {
        this.finishDate = finishDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setParametersXml(String parametersXml) {
        this.parametersXml = parametersXml;
    }

    public void setRecipientEmail(String recipientEmail) {
        this.recipientEmail = recipientEmail;
    }

    public void setReplyToJms(Boolean replyToJms) {
        this.replyToJms = replyToJms;
    }

    public void setReport(ReportTemplate report) {
        this.report = report;
    }

    public void setReportResult(String reportResult) {
        this.reportResult = reportResult;
    }

    public void setReportStatus(Status reportStatus) {
        this.reportStatus = reportStatus;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ReportOrder shallowCopy() {
        ReportOrder copy = new ReportOrder();
        copy.setOutputFormat(this.getOutputFormat());
        copy.setParametersXml(this.getParametersXml());
        copy.setRecipientEmail(this.getRecipientEmail());
        copy.setReplyToJms(this.getReplyToJms());
        copy.setReport(this.getReport());
        copy.setUsername(this.getUsername());
        return copy;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", id: " + this.id;
    }

    public static enum Status {
        NEW,
        PROCESSING,
        SUCCEEDED,
        FAILED;

    }
}

