/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ar_report_template")
public class ReportTemplate
implements Serializable {
    private static final long serialVersionUID = -7196776812526154079L;
    public static final long ACCESS_ALL_ROLES_ID = -1L;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="ar_roles_with_access", joinColumns={@JoinColumn(name="report_id")})
    @Column(name="role_id")
    private Set<Long> rolesWithAccess = new HashSet<Long>();
    @Column
    private Boolean active = true;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column
    @Basic(fetch=FetchType.LAZY)
    private String content;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=false)
    private Date created = new Date();
    @Column
    private String description;
    @Column(nullable=false)
    private String filename;
    @Column(name="allow_online_display")
    private Boolean allowOnlineDisplay = true;
    @Column(name="allow_background_order")
    private Boolean allowBackgroundOrder = true;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @PrimaryKeyJoinColumn
    @Column(name="id", nullable=false, length=10)
    private Integer id;
    @Column(unique=true, nullable=false)
    private String reportname;

    public boolean getActive() {
        return this.active != null && this.active != false;
    }

    public String getContent() {
        return this.content;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilename() {
        return this.filename;
    }

    public Integer getId() {
        return this.id;
    }

    public String getReportname() {
        return this.reportname;
    }

    public Boolean getAllowBackgroundOrder() {
        return this.allowBackgroundOrder != null && this.allowBackgroundOrder != false;
    }

    public Boolean getAllowOnlineDisplay() {
        return this.allowOnlineDisplay != null && this.allowOnlineDisplay != false;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setAllowBackgroundOrder(Boolean allowBackgroundOrder) {
        this.allowBackgroundOrder = allowBackgroundOrder;
    }

    public void setAllowOnlineDisplay(Boolean allowOnlineDisplay) {
        this.allowOnlineDisplay = allowOnlineDisplay;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setReportname(String reportname) {
        this.reportname = reportname;
    }

    public boolean isAccessibleForAllRoles() {
        return this.rolesWithAccess.size() == 1 && this.rolesWithAccess.contains(-1L);
    }

    public Set<Long> getRolesWithAccess() {
        return this.rolesWithAccess;
    }

    public void setAccessibleForAllRoles() {
        this.rolesWithAccess.clear();
        this.rolesWithAccess.add(-1L);
    }

    public void setRolesWithAccess(Set<Long> rolesWithAccess) {
        this.rolesWithAccess = rolesWithAccess;
    }

    public boolean hasRoleAccess(Long roleId) {
        return this.rolesWithAccess.contains(-1L) || this.rolesWithAccess.contains(roleId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reportname == null ? 0 : this.reportname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportTemplate other = (ReportTemplate)obj;
        return !(this.reportname == null ? other.reportname != null : !this.reportname.equals(other.reportname));
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", id: " + this.id;
    }
}

