/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.ws.endpoint;

import java.io.IOException;
import java.util.logging.Logger;
import org.apertereports.common.ConfigurationConstants;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsException;
import org.apertereports.common.utils.ReportGeneratorUtils;
import org.apertereports.common.xml.ws.GenerateReportRequest;
import org.apertereports.common.xml.ws.GenerateReportResponse;
import org.apertereports.common.xml.ws.ObjectFactory;
import org.apertereports.common.xml.ws.ReportData;
import org.apertereports.engine.ReportWebServiceHelper;
import org.apertereports.ws.exception.ReportWebServiceException;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;

@Endpoint
public class ReportGeneratorEndpoint
implements ReportConstants,
ConfigurationConstants {
    private static final Logger logger = Logger.getLogger(ReportGeneratorEndpoint.class.getName());
    private static final ObjectFactory objectFactory = new ObjectFactory();
    private ReportWebServiceHelper helper = new ReportWebServiceHelper();

    @PayloadRoot(localPart="GenerateReportRequest", namespace="http://bluesoft.net.pl/rnd/apertereports/schemas")
    @ResponsePayload
    public GenerateReportResponse generateReport(@RequestPayload GenerateReportRequest request) throws ReportWebServiceException {
        ReportData reportData = request.getReportData();
        String mimeType = ReportConstants.ReportMimeType.valueOf((String)reportData.getFormat()).mimeType();
        GenerateReportResponse response = objectFactory.createGenerateReportResponse();
        response.setMimeType(mimeType);
        response.setReportFormat(reportData.getFormat());
        try {
            byte[] content = this.helper.generateAndExportReport(reportData);
            response.setContent(ReportGeneratorUtils.wrapBytesInDataHandler((byte[])content, (String)mimeType));
        }
        catch (AperteReportsException e) {
            throw new ReportWebServiceException(e);
        }
        catch (IOException e) {
            logger.info(e.getMessage());
            throw new ReportWebServiceException(ReportConstants.ErrorCodes.JASPER_REPORTS_EXCEPTION, "Exception while generating report: " + (reportData.getName() != null ? reportData.getName() : reportData.getId()) + ". Detailed message: " + e.getMessage());
        }
        return response;
    }
}

