/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.ws.utils;

import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class ClasspathScanningJAXB2Marshaller
extends Jaxb2Marshaller {
    private String basePackage;

    public ClasspathScanningJAXB2Marshaller() {
    }

    public ClasspathScanningJAXB2Marshaller(String basePackage) {
        this.basePackage = basePackage;
    }

    public final Class<?>[] getXMLRootClasses() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(XmlRootElement.class));
        try {
            Set components = scanner.findCandidateComponents(this.basePackage);
            Class[] result = new Class[components.size()];
            int i = 0;
            for (BeanDefinition bd : components) {
                result[i++] = ((Object)((Object)this)).getClass().getClassLoader().loadClass(bd.getBeanClassName());
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        this.setClassesToBeBound(this.getXMLRootClasses());
    }
}

