/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.ws.exception;

import org.apache.commons.lang.StringUtils;
import org.apertereports.common.ReportConstants;
import org.apertereports.common.exception.AperteReportsException;
import org.springframework.ws.soap.server.endpoint.annotation.FaultCode;
import org.springframework.ws.soap.server.endpoint.annotation.SoapFault;

@SoapFault(faultCode=FaultCode.SERVER)
public class ReportWebServiceException
extends Exception {
    private ReportConstants.ErrorCodes errorCode;
    private String errorDesc;

    public ReportWebServiceException(AperteReportsException e) {
        super(e.getMessage(), e.getCause());
        this.errorCode = e.getErrorCode();
        this.errorDesc = StringUtils.join((Object[])e.getErrorDetails(), (String)", ");
    }

    public ReportWebServiceException(ReportConstants.ErrorCodes errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        this.errorDesc = message;
    }

    public ReportWebServiceException(ReportConstants.ErrorCodes errorCode, String message, Throwable e) {
        super(message, e);
        this.errorCode = errorCode;
        this.errorDesc = message;
    }

    public ReportWebServiceException(Throwable cause) {
        super(cause);
    }

    public ReportConstants.ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }
}

