/*
 * Decompiled with CFR 0.152.
 */
package org.apertereports.ws.exception;

import org.apache.commons.lang.StringUtils;
import org.apertereports.common.ARConstants;
import org.apertereports.common.exception.ARException;
import org.springframework.ws.soap.server.endpoint.annotation.FaultCode;
import org.springframework.ws.soap.server.endpoint.annotation.SoapFault;

@SoapFault(faultCode=FaultCode.SERVER)
public class ReportWebServiceException
extends Exception {
    private ARConstants.ErrorCode errorCode;
    private String errorDesc;

    public ReportWebServiceException(ARException e) {
        super(e.getMessage(), e.getCause());
        this.errorCode = e.getErrorCode();
        this.errorDesc = StringUtils.join((Object[])e.getErrorDetails(), (String)", ");
    }

    public ReportWebServiceException(ARConstants.ErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        this.errorDesc = message;
    }

    public ReportWebServiceException(ARConstants.ErrorCode errorCode, String message, Throwable e) {
        super(message, e);
        this.errorCode = errorCode;
        this.errorDesc = message;
    }

    public ReportWebServiceException(Throwable cause) {
        super(cause);
    }

    public ARConstants.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }
}

