/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.emul.zip;

import org.apidesign.bck2brwsr.emul.zip.Inflate;
import org.apidesign.bck2brwsr.emul.zip.ZStream;

final class JzLibInflater
extends ZStream {
    private static final int MAX_WBITS = 15;
    private static final int DEF_WBITS = 15;
    public static final int Z_NO_FLUSH = 0;
    private static final int Z_PARTIAL_FLUSH = 1;
    private static final int Z_SYNC_FLUSH = 2;
    private static final int Z_FULL_FLUSH = 3;
    private static final int Z_FINISH = 4;
    private static final int MAX_MEM_LEVEL = 9;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private boolean finished = false;

    public JzLibInflater() {
        this.init();
    }

    public JzLibInflater(int w) {
        this(w, false);
    }

    public JzLibInflater(int w, boolean nowrap) {
        int ret = this.init(w, nowrap);
        if (ret != 0) {
            throw new IllegalStateException(ret + ": " + this.msg);
        }
    }

    public int init() {
        return this.init(15);
    }

    public int init(boolean nowrap) {
        return this.init(15, nowrap);
    }

    public int init(int w) {
        return this.init(w, false);
    }

    public int init(int w, boolean nowrap) {
        this.finished = false;
        this.istate = new Inflate(this);
        return this.istate.inflateInit(nowrap ? -w : w);
    }

    @Override
    public int inflate(int f) {
        if (this.istate == null) {
            return -2;
        }
        int ret = this.istate.inflate(f);
        if (ret == 1) {
            this.finished = true;
        }
        return ret;
    }

    @Override
    public int end() {
        this.finished = true;
        if (this.istate == null) {
            return -2;
        }
        int ret = this.istate.inflateEnd();
        return ret;
    }

    public int sync() {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSync();
    }

    public int syncPoint() {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSyncPoint();
    }

    public int setDictionary(byte[] dictionary, int dictLength) {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflateSetDictionary(dictionary, dictLength);
    }

    @Override
    public boolean finished() {
        return this.istate.mode == 12;
    }

    public boolean needDict() {
        return this.istate == null ? false : this.istate.mode == 6;
    }
}

