/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    long time = -1L;
    long crc = -1L;
    long size = -1L;
    long csize = -1L;
    int method = -1;
    int flag = 0;
    byte[] extra;
    String comment;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException("entry name too long");
        }
        this.name = name;
    }

    public ZipEntry(ZipEntry e) {
        this.name = e.name;
        this.time = e.time;
        this.crc = e.crc;
        this.size = e.size;
        this.csize = e.csize;
        this.method = e.method;
        this.flag = e.flag;
        this.extra = e.extra;
        this.comment = e.comment;
    }

    ZipEntry() {
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long time) {
        this.time = ZipEntry.javaToDosTime(time);
    }

    public long getTime() {
        return this.time != -1L ? ZipEntry.dosToJavaTime(this.time) : -1L;
    }

    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setCompressedSize(long csize) {
        this.csize = csize;
    }

    public void setCrc(long crc) {
        if (crc < 0L || crc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = crc;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = method;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] extra) {
        if (extra != null && extra.length > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
        this.extra = extra;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public String toString() {
        return this.getName();
    }

    private static long dosToJavaTime(long dtime) {
        return dtime;
    }

    private static long javaToDosTime(long time) {
        return time;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Object clone() {
        try {
            ZipEntry e = (ZipEntry)super.clone();
            e.extra = this.extra == null ? null : (byte[])this.extra.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

