/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.bck2brwsr.emul.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apidesign.bck2brwsr.core.Exported;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class FastJar {
    private final byte[] arr;
    private static final int GIVE_UP = 65536;

    public FastJar(byte[] arr) {
        this.arr = arr;
    }

    public InputStream getInputStream(Entry e) throws IOException {
        return FastJar.getInputStream(this.arr, e.offset);
    }

    private static InputStream getInputStream(byte[] arr, long offset) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(arr);
        is.skip(offset);
        ZipInputStream in = new ZipInputStream(is);
        ZipEntry e = in.getNextEntry();
        if (e != null && e.getCrc() == 0L && e.getMethod() == 0) {
            int cp = arr.length - is.available();
            return new ByteArrayInputStream(arr, cp, (int)e.getSize());
        }
        return in;
    }

    public Entry[] list() throws IOException {
        int size = this.arr.length;
        int at = size - 22;
        byte[] data = new byte[22];
        int giveup = 0;
        do {
            FastJar.arraycopy(this.arr, at, data, 0, data.length);
            --at;
            if (++giveup <= 65536) continue;
            throw new IOException();
        } while (FastJar.getsig(data) != 101010256L);
        long censize = FastJar.endsiz(data);
        long cenoff = FastJar.endoff(data);
        at = (int)cenoff;
        Entry[] result = new Entry[]{};
        int cenread = 0;
        data = new byte[46];
        while ((long)cenread < censize) {
            FastJar.arraycopy(this.arr, at, data, 0, data.length);
            at += data.length;
            if (FastJar.getsig(data) != 33639248L) {
                throw new IOException("No central table");
            }
            int cennam = FastJar.cennam(data);
            int cenext = FastJar.cenext(data);
            int cencom = FastJar.cencom(data);
            long lhoff = FastJar.cenoff(data);
            long centim = FastJar.centim(data);
            String name = new String(this.arr, at, cennam, "UTF-8");
            at += cennam;
            int seekby = cenext + cencom;
            int cendatalen = 46 + cennam + seekby;
            cenread += cendatalen;
            result = this.addEntry(result, new Entry(name, lhoff, centim));
            at += seekby;
        }
        return result;
    }

    private Entry[] addEntry(Entry[] result, Entry entry) {
        Entry[] e = new Entry[result.length + 1];
        e[result.length] = entry;
        FastJar.arraycopy(result, 0, e, 0, result.length);
        return e;
    }

    private static final long getsig(byte[] b) throws IOException {
        return FastJar.get32(b, 0);
    }

    private static final long endsiz(byte[] b) throws IOException {
        return FastJar.get32(b, 12);
    }

    private static final long endoff(byte[] b) throws IOException {
        return FastJar.get32(b, 16);
    }

    private static final long cenlen(byte[] b) throws IOException {
        return FastJar.get32(b, 24);
    }

    private static final long censiz(byte[] b) throws IOException {
        return FastJar.get32(b, 20);
    }

    private static final long centim(byte[] b) throws IOException {
        return FastJar.get32(b, 12);
    }

    private static final int cennam(byte[] b) throws IOException {
        return FastJar.get16(b, 28);
    }

    private static final int cenext(byte[] b) throws IOException {
        return FastJar.get16(b, 30);
    }

    private static final int cencom(byte[] b) throws IOException {
        return FastJar.get16(b, 32);
    }

    private static final long cenoff(byte[] b) throws IOException {
        return FastJar.get32(b, 42);
    }

    private static final int lochow(byte[] b) throws IOException {
        return FastJar.get16(b, 8);
    }

    private static final int locname(byte[] b) throws IOException {
        return FastJar.get16(b, 26);
    }

    private static final int locext(byte[] b) throws IOException {
        return FastJar.get16(b, 28);
    }

    private static final long locsiz(byte[] b) throws IOException {
        return FastJar.get32(b, 18);
    }

    private static final int get16(byte[] b, int off) throws IOException {
        byte b1 = b[off];
        byte b2 = b[off + 1];
        return b1 & 0xFF | (b2 & 0xFF) << 8;
    }

    private static final long get32(byte[] b, int off) throws IOException {
        int s1 = FastJar.get16(b, off);
        int s2 = FastJar.get16(b, off + 2);
        return (long)s1 | (long)s2 << 16;
    }

    @JavaScriptBody(args={"value", "srcBegin", "dst", "dstBegin", "count"}, body="if (srcBegin < dstBegin) {\n    while (count-- > 0) {\n        dst[dstBegin + count] = value[srcBegin + count];\n    }\n} else {\n    while (count-- > 0) {\n        dst[dstBegin++] = value[srcBegin++];\n    }\n}")
    @Exported
    static void arraycopy(Object src, int srcBegin, Object dst, int dstBegin, int count) {
        try {
            Class<?> system = Class.forName("java.lang.System");
            Method m = system.getMethod("arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
            m.invoke(null, src, srcBegin, dst, dstBegin, count);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static final class Entry {
        public final String name;
        final long offset;
        private final long dosTime;

        Entry(String name, long offset, long time) {
            assert (name != null);
            this.name = name;
            this.offset = offset;
            this.dosTime = time;
        }
    }
}

