/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.kofx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.PropertyBinding;
import org.apidesign.html.kofx.Console;

public final class Knockout {
    private static final Logger LOG = Logger.getLogger(Knockout.class.getName());
    static Knockout next;
    private final Object model;

    Knockout(Object model) {
        this.model = model == null ? this : model;
    }

    public Object koData() {
        return this.model;
    }

    static Object toArray(Object[] arr) {
        return InvokeJS.KObject.call("array", arr);
    }

    public static <M> Knockout createBinding(Object model) {
        Object bindings = InvokeJS.KObject.call("create", model);
        return new Knockout(bindings);
    }

    public void valueHasMutated(String prop) {
        Knockout.valueHasMutated((JSObject)this.model, prop);
    }

    public static void valueHasMutated(JSObject model, String prop) {
        LOG.log(Level.FINE, "property mutated: {0}", prop);
        try {
            Object koProp = model.getMember(prop);
            if (koProp instanceof JSObject) {
                ((JSObject)koProp).call("valueHasMutated", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "valueHasMutated failed for " + model + " prop: " + prop, t);
        }
    }

    static void bind(Object bindings, Object model, PropertyBinding pb, boolean primitive, boolean array) {
        WebEngine e = Knockout.web();
        if (e == null) {
            return;
        }
        String prop = pb.getPropertyName();
        try {
            InvokeJS.KObject.call("bind", bindings, pb, prop, "getValue", pb.isReadOnly() ? null : "setValue", primitive, array);
            ((JSObject)bindings).setMember("ko-fx.model", model);
            LOG.log(Level.FINE, "binding defined for {0}: {1}", new Object[]{prop, ((JSObject)bindings).getMember(prop)});
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "binding failed for {0} on {1}", new Object[]{prop, bindings});
        }
    }

    static void expose(Object bindings, FunctionBinding f) {
        WebEngine e = Knockout.web();
        if (e == null) {
            return;
        }
        String prop = f.getFunctionName();
        try {
            InvokeJS.KObject.call("expose", bindings, f, prop, "call");
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Cannot define binding for " + prop + " in model " + f, ex);
        }
    }

    static void applyBindings(Object bindings) {
        if (Knockout.web() != null) {
            JSObject ko = (JSObject)Knockout.web().executeScript("ko");
            ko.call("applyBindings", bindings);
        }
    }

    static WebEngine web() {
        return (WebEngine)System.getProperties().get("webEngine");
    }

    private static final class InvokeJS {
        static final JSObject KObject;

        private InvokeJS() {
        }

        static {
            InputStream koScript = Knockout.class.getResourceAsStream("knockout-2.2.1.js");
            assert (koScript != null) : "Can't load knockout.js";
            BufferedReader r = new BufferedReader(new InputStreamReader(koScript));
            StringBuilder sb = new StringBuilder();
            try {
                String l;
                while ((l = r.readLine()) != null) {
                    sb.append(l).append('\n');
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            Knockout.web().executeScript(sb.toString());
            Object ko = Knockout.web().executeScript("ko");
            assert (ko != null) : "Knockout library successfully defined 'ko'";
            Console.register(Knockout.web());
            KObject = (JSObject)Knockout.web().executeScript("(function(scope) {  var kCnt = 0;   scope.KObject = {};  scope.KObject.create= function(value) {    var cnt = ++kCnt;    var ret = {};    ret.toString = function() { return 'KObject' + cnt + ' value: ' + value + ' props: ' + Object.keys(this); };    return ret;  };  scope.KObject.array= function() {    return Array.prototype.slice.call(arguments);  };  scope.KObject.expose = function(bindings, model, prop, sig) {    bindings[prop] = function(data, ev) {      model[sig](data, ev);    };  };  scope.KObject.bind = function(bindings, model, prop, getter, setter, primitive, array) {    var bnd = {      read: function() {      try {        var v = model[getter]();        return v;      } catch (e) {        alert(\"Cannot call \" + getter + \" on \" + model + \" error: \" + e);      }    },    owner: bindings    };    if (setter != null) {      bnd.write = function(val) {        model[setter](primitive ? new Number(val) : val);      };    };    bindings[prop] = ko.computed(bnd);  };})(window); window.KObject");
        }
    }
}

